/*
 * Decompiled with CFR 0.152.
 */
package io.opentracing.contrib.common;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashSet;

public final class Classes {
    private static void recurse(Class<?> iface, HashSet<Class<?>> set) {
        if (set.contains(iface)) {
            return;
        }
        set.add(iface);
        for (Class<?> extended : iface.getInterfaces()) {
            Classes.recurse(extended, set);
        }
    }

    public static Class<?>[] getAllInterfaces(Class<?> cls) {
        Class<?> parent = cls;
        HashSet set = null;
        do {
            Class<?>[] ifaces;
            if ((ifaces = parent.getInterfaces()).length == 0) continue;
            if (set == null) {
                set = new HashSet(4);
            }
            for (Class<?> iface : ifaces) {
                Classes.recurse(iface, set);
            }
        } while ((parent = parent.getSuperclass()) != null);
        return set.toArray(new Class[set.size()]);
    }

    public static Method getDeclaredMethod(Class<?> cls, String name, Class<?> ... parameterTypes) {
        Method[] methods;
        for (Method method : methods = cls.getDeclaredMethods()) {
            if (!name.equals(method.getName()) || !Arrays.equals(method.getParameterTypes(), parameterTypes)) continue;
            return method;
        }
        return null;
    }

    public static Method getDeclaredMethodDeep(Class<?> cls, String name, Class<?> ... parameterTypes) {
        Method method;
        while ((method = Classes.getDeclaredMethod(cls, name, parameterTypes)) == null && (cls = cls.getSuperclass()) != null) {
        }
        return method;
    }

    private Classes() {
    }
}

