/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.internal;

import io.opentelemetry.api.incubator.ExtendedOpenTelemetry;
import io.opentelemetry.api.incubator.config.ConfigProvider;
import io.opentelemetry.api.incubator.config.DeclarativeConfigProperties;
import io.opentelemetry.sdk.OpenTelemetrySdk;
import io.opentelemetry.sdk.internal.SdkConfigProvider;
import javax.annotation.concurrent.ThreadSafe;

public final class ExtendedOpenTelemetrySdk
extends OpenTelemetrySdk
implements ExtendedOpenTelemetry {
    private final OpenTelemetrySdk openTelemetrySdk;
    private final ObfuscatedConfigProvider configProvider;

    private ExtendedOpenTelemetrySdk(OpenTelemetrySdk openTelemetrySdk, SdkConfigProvider configProvider) {
        super(openTelemetrySdk.getSdkTracerProvider(), openTelemetrySdk.getSdkMeterProvider(), openTelemetrySdk.getSdkLoggerProvider(), openTelemetrySdk.getPropagators());
        this.openTelemetrySdk = openTelemetrySdk;
        this.configProvider = new ObfuscatedConfigProvider(configProvider);
    }

    public static ExtendedOpenTelemetrySdk create(OpenTelemetrySdk openTelemetrySdk, SdkConfigProvider sdkConfigProvider) {
        return new ExtendedOpenTelemetrySdk(openTelemetrySdk, sdkConfigProvider);
    }

    public ConfigProvider getConfigProvider() {
        return this.configProvider;
    }

    public SdkConfigProvider getSdkConfigProvider() {
        return this.configProvider.unobfuscate();
    }

    @Override
    public String toString() {
        return "ExtendedOpenTelemetrySdk{openTelemetrySdk=" + this.openTelemetrySdk + ", configProvider=" + this.configProvider.unobfuscate() + "}";
    }

    @ThreadSafe
    private static class ObfuscatedConfigProvider
    implements ConfigProvider {
        private final SdkConfigProvider delegate;

        private ObfuscatedConfigProvider(SdkConfigProvider delegate) {
            this.delegate = delegate;
        }

        public DeclarativeConfigProperties getInstrumentationConfig() {
            return this.delegate.getInstrumentationConfig();
        }

        private SdkConfigProvider unobfuscate() {
            return this.delegate;
        }
    }
}

