/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk;

import io.opentelemetry.api.GlobalOpenTelemetry;
import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.context.propagation.ContextPropagators;
import io.opentelemetry.sdk.IncubatingUtil;
import io.opentelemetry.sdk.OpenTelemetrySdk;
import io.opentelemetry.sdk.internal.SdkConfigProvider;
import io.opentelemetry.sdk.logs.SdkLoggerProvider;
import io.opentelemetry.sdk.metrics.SdkMeterProvider;
import io.opentelemetry.sdk.trace.SdkTracerProvider;
import java.util.Objects;
import javax.annotation.Nullable;

public final class OpenTelemetrySdkBuilder {
    private ContextPropagators propagators = ContextPropagators.noop();
    @Nullable
    private SdkTracerProvider tracerProvider;
    @Nullable
    private SdkMeterProvider meterProvider;
    @Nullable
    private SdkLoggerProvider loggerProvider;
    @Nullable
    private Object configProvider;
    private static final boolean INCUBATOR_AVAILABLE;

    OpenTelemetrySdkBuilder() {
    }

    public OpenTelemetrySdkBuilder setTracerProvider(SdkTracerProvider tracerProvider) {
        this.tracerProvider = tracerProvider;
        return this;
    }

    public OpenTelemetrySdkBuilder setMeterProvider(SdkMeterProvider meterProvider) {
        this.meterProvider = meterProvider;
        return this;
    }

    public OpenTelemetrySdkBuilder setLoggerProvider(SdkLoggerProvider loggerProvider) {
        this.loggerProvider = loggerProvider;
        return this;
    }

    public OpenTelemetrySdkBuilder setPropagators(ContextPropagators propagators) {
        this.propagators = Objects.requireNonNull(propagators);
        return this;
    }

    OpenTelemetrySdkBuilder setConfigProvider(SdkConfigProvider configProvider) {
        this.configProvider = Objects.requireNonNull(configProvider);
        return this;
    }

    public OpenTelemetrySdk buildAndRegisterGlobal() {
        OpenTelemetrySdk sdk = this.build();
        GlobalOpenTelemetry.set((OpenTelemetry)sdk);
        return sdk;
    }

    public OpenTelemetrySdk build() {
        SdkLoggerProvider loggerProvider;
        SdkMeterProvider meterProvider;
        SdkTracerProvider tracerProvider = this.tracerProvider;
        if (tracerProvider == null) {
            tracerProvider = SdkTracerProvider.builder().build();
        }
        if ((meterProvider = this.meterProvider) == null) {
            meterProvider = SdkMeterProvider.builder().build();
        }
        if ((loggerProvider = this.loggerProvider) == null) {
            loggerProvider = SdkLoggerProvider.builder().build();
        }
        OpenTelemetrySdk openTelemetrySdk = new OpenTelemetrySdk(tracerProvider, meterProvider, loggerProvider, this.propagators);
        return INCUBATOR_AVAILABLE ? IncubatingUtil.createExtendedOpenTelemetrySdk(openTelemetrySdk, this.configProvider) : openTelemetrySdk;
    }

    static {
        boolean incubatorAvailable = false;
        try {
            Class.forName("io.opentelemetry.api.incubator.ExtendedOpenTelemetry");
            incubatorAvailable = true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        INCUBATOR_AVAILABLE = incubatorAvailable;
    }
}

