/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.resources;

import com.google.auto.value.AutoValue;
import com.google.auto.value.extension.memoized.Memoized;
import io.opentelemetry.common.AttributeValue;
import io.opentelemetry.common.Attributes;
import io.opentelemetry.common.ReadableAttributes;
import io.opentelemetry.common.ReadableKeyValuePairs;
import io.opentelemetry.internal.StringUtils;
import io.opentelemetry.internal.Utils;
import io.opentelemetry.sdk.resources.AutoValue_Resource;
import io.opentelemetry.sdk.resources.EnvAutodetectResource;
import java.util.Objects;
import java.util.Properties;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
@AutoValue
public abstract class Resource {
    private static final int MAX_LENGTH = 255;
    private static final String ERROR_MESSAGE_INVALID_CHARS = " should be a ASCII string with a length greater than 0 and not exceed 255 characters.";
    private static final String ERROR_MESSAGE_INVALID_VALUE = " should be a ASCII string with a length not exceed 255 characters.";
    private static final Resource EMPTY = Resource.create(Attributes.empty());
    private static final Resource TELEMETRY_SDK = Resource.create(Attributes.newBuilder().setAttribute("telemetry.sdk.name", "opentelemetry").setAttribute("telemetry.sdk.language", "java").setAttribute("telemetry.sdk.version", Resource.readVersion()).build());
    private static final Resource DEFAULT = ((EnvAutodetectResource.Builder)((EnvAutodetectResource.Builder)new EnvAutodetectResource.Builder().readEnvironmentVariables()).readSystemProperties()).build();

    @Nullable
    private static String readVersion() {
        Properties properties = new Properties();
        try {
            properties.load(Resource.class.getResourceAsStream("/io/opentelemetry/sdk/version.properties"));
        }
        catch (Exception e) {
            return "unknown";
        }
        return properties.getProperty("sdk.version");
    }

    Resource() {
    }

    public static Resource getEmpty() {
        return EMPTY;
    }

    public static Resource getTelemetrySdk() {
        return TELEMETRY_SDK;
    }

    public abstract ReadableAttributes getAttributes();

    @Memoized
    public abstract int hashCode();

    public static Resource create(Attributes attributes) {
        Resource.checkAttributes((ReadableAttributes)Objects.requireNonNull(attributes, "attributes"));
        return new AutoValue_Resource((ReadableAttributes)attributes);
    }

    public static Resource getDefault() {
        return DEFAULT;
    }

    public Resource merge(@Nullable Resource other) {
        if (other == null) {
            return this;
        }
        Attributes.Builder attrBuilder = Attributes.newBuilder();
        Merger merger = new Merger(attrBuilder);
        this.getAttributes().forEach((ReadableKeyValuePairs.KeyValueConsumer)merger);
        other.getAttributes().forEach((ReadableKeyValuePairs.KeyValueConsumer)merger);
        return new AutoValue_Resource((ReadableAttributes)attrBuilder.build());
    }

    private static void checkAttributes(ReadableAttributes attributes) {
        attributes.forEach((ReadableKeyValuePairs.KeyValueConsumer)new ReadableKeyValuePairs.KeyValueConsumer<AttributeValue>(){

            public void consume(String key, AttributeValue value) {
                Utils.checkArgument((boolean)Resource.isValidAndNotEmpty(key), (String)"Attribute key should be a ASCII string with a length greater than 0 and not exceed 255 characters.");
                Objects.requireNonNull(value, "Attribute value should be a ASCII string with a length not exceed 255 characters.");
            }
        });
    }

    private static boolean isValid(String name) {
        return name.length() <= 255 && StringUtils.isPrintableString((String)name);
    }

    private static boolean isValidAndNotEmpty(String name) {
        return !name.isEmpty() && Resource.isValid(name);
    }

    private static final class Merger
    implements ReadableKeyValuePairs.KeyValueConsumer<AttributeValue> {
        private final Attributes.Builder attrBuilder;

        private Merger(Attributes.Builder attrBuilder) {
            this.attrBuilder = attrBuilder;
        }

        public void consume(String key, AttributeValue value) {
            this.attrBuilder.setAttribute(key, value);
        }
    }
}

