/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.metrics;

import io.opentelemetry.common.Labels;
import io.opentelemetry.metrics.LongUpDownCounter;
import io.opentelemetry.sdk.metrics.AbstractBoundInstrument;
import io.opentelemetry.sdk.metrics.AbstractInstrument;
import io.opentelemetry.sdk.metrics.AbstractSynchronousInstrument;
import io.opentelemetry.sdk.metrics.ActiveBatcher;
import io.opentelemetry.sdk.metrics.Batcher;
import io.opentelemetry.sdk.metrics.InstrumentDescriptor;
import io.opentelemetry.sdk.metrics.MeterProviderSharedState;
import io.opentelemetry.sdk.metrics.MeterSdk;
import io.opentelemetry.sdk.metrics.MeterSharedState;
import io.opentelemetry.sdk.metrics.common.InstrumentType;
import io.opentelemetry.sdk.metrics.common.InstrumentValueType;

final class LongUpDownCounterSdk
extends AbstractSynchronousInstrument<BoundInstrument>
implements LongUpDownCounter {
    private LongUpDownCounterSdk(InstrumentDescriptor descriptor, MeterProviderSharedState meterProviderSharedState, MeterSharedState meterSharedState, Batcher batcher) {
        super(descriptor, meterProviderSharedState, meterSharedState, new ActiveBatcher(batcher));
    }

    public void add(long increment, Labels labels) {
        BoundInstrument boundInstrument = (BoundInstrument)this.bind(labels);
        boundInstrument.add(increment);
        boundInstrument.unbind();
    }

    @Override
    BoundInstrument newBinding(Batcher batcher) {
        return new BoundInstrument(batcher);
    }

    static final class Builder
    extends AbstractInstrument.Builder<Builder>
    implements LongUpDownCounter.Builder {
        Builder(String name, MeterProviderSharedState meterProviderSharedState, MeterSharedState meterSharedState, MeterSdk meterSdk) {
            super(name, meterProviderSharedState, meterSharedState, meterSdk);
        }

        @Override
        Builder getThis() {
            return this;
        }

        public LongUpDownCounterSdk build() {
            InstrumentDescriptor instrumentDescriptor = this.getInstrumentDescriptor(InstrumentType.UP_DOWN_COUNTER, InstrumentValueType.LONG);
            return this.register(new LongUpDownCounterSdk(instrumentDescriptor, this.getMeterProviderSharedState(), this.getMeterSharedState(), this.getBatcher(instrumentDescriptor)));
        }
    }

    static final class BoundInstrument
    extends AbstractBoundInstrument
    implements LongUpDownCounter.BoundLongUpDownCounter {
        BoundInstrument(Batcher batcher) {
            super(batcher.getAggregator());
        }

        public void add(long increment) {
            this.recordLong(increment);
        }
    }
}

