/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.metrics;

import io.opentelemetry.common.Labels;
import io.opentelemetry.metrics.DoubleValueRecorder;
import io.opentelemetry.sdk.metrics.AbstractBoundInstrument;
import io.opentelemetry.sdk.metrics.AbstractInstrument;
import io.opentelemetry.sdk.metrics.AbstractSynchronousInstrument;
import io.opentelemetry.sdk.metrics.ActiveBatcher;
import io.opentelemetry.sdk.metrics.Batcher;
import io.opentelemetry.sdk.metrics.InstrumentDescriptor;
import io.opentelemetry.sdk.metrics.MeterProviderSharedState;
import io.opentelemetry.sdk.metrics.MeterSdk;
import io.opentelemetry.sdk.metrics.MeterSharedState;
import io.opentelemetry.sdk.metrics.common.InstrumentType;
import io.opentelemetry.sdk.metrics.common.InstrumentValueType;

final class DoubleValueRecorderSdk
extends AbstractSynchronousInstrument<BoundInstrument>
implements DoubleValueRecorder {
    private DoubleValueRecorderSdk(InstrumentDescriptor descriptor, MeterProviderSharedState meterProviderSharedState, MeterSharedState meterSharedState, Batcher batcher) {
        super(descriptor, meterProviderSharedState, meterSharedState, new ActiveBatcher(batcher));
    }

    public void record(double value, Labels labels) {
        BoundInstrument boundInstrument = (BoundInstrument)this.bind(labels);
        boundInstrument.record(value);
        boundInstrument.unbind();
    }

    @Override
    BoundInstrument newBinding(Batcher batcher) {
        return new BoundInstrument(batcher);
    }

    static final class Builder
    extends AbstractInstrument.Builder<Builder>
    implements DoubleValueRecorder.Builder {
        Builder(String name, MeterProviderSharedState meterProviderSharedState, MeterSharedState meterSharedState, MeterSdk meterSdk) {
            super(name, meterProviderSharedState, meterSharedState, meterSdk);
        }

        @Override
        Builder getThis() {
            return this;
        }

        public DoubleValueRecorderSdk build() {
            InstrumentDescriptor instrumentDescriptor = this.getInstrumentDescriptor(InstrumentType.VALUE_RECORDER, InstrumentValueType.DOUBLE);
            return this.register(new DoubleValueRecorderSdk(instrumentDescriptor, this.getMeterProviderSharedState(), this.getMeterSharedState(), this.getBatcher(instrumentDescriptor)));
        }
    }

    static final class BoundInstrument
    extends AbstractBoundInstrument
    implements DoubleValueRecorder.BoundDoubleValueRecorder {
        BoundInstrument(Batcher batcher) {
            super(batcher.getAggregator());
        }

        public void record(double value) {
            this.recordDouble(value);
        }
    }
}

