/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.trace.data;

import com.google.auto.value.AutoValue;
import io.opentelemetry.common.Attributes;
import io.opentelemetry.common.ReadableAttributes;
import io.opentelemetry.sdk.common.InstrumentationLibraryInfo;
import io.opentelemetry.sdk.resources.Resource;
import io.opentelemetry.sdk.trace.data.AutoValue_SpanData_Link;
import io.opentelemetry.trace.Span;
import io.opentelemetry.trace.SpanContext;
import io.opentelemetry.trace.SpanId;
import io.opentelemetry.trace.Status;
import io.opentelemetry.trace.TraceFlags;
import io.opentelemetry.trace.TraceId;
import io.opentelemetry.trace.TraceState;
import java.util.List;
import javax.annotation.concurrent.Immutable;

@Immutable
public interface SpanData {
    public TraceId getTraceId();

    public SpanId getSpanId();

    public TraceFlags getTraceFlags();

    public TraceState getTraceState();

    public SpanId getParentSpanId();

    public Resource getResource();

    public InstrumentationLibraryInfo getInstrumentationLibraryInfo();

    public String getName();

    public Span.Kind getKind();

    public long getStartEpochNanos();

    public ReadableAttributes getAttributes();

    public List<Event> getEvents();

    public List<Link> getLinks();

    public Status getStatus();

    public long getEndEpochNanos();

    public boolean getHasRemoteParent();

    public boolean getHasEnded();

    public int getTotalRecordedEvents();

    public int getTotalRecordedLinks();

    public int getTotalAttributeCount();

    public static interface Event
    extends io.opentelemetry.trace.Event {
        public long getEpochNanos();

        public int getTotalAttributeCount();
    }

    @Immutable
    @AutoValue
    public static abstract class Link
    implements io.opentelemetry.trace.Link {
        private static final Attributes DEFAULT_ATTRIBUTE_COLLECTION = Attributes.empty();
        private static final int DEFAULT_ATTRIBUTE_COUNT = 0;

        public static Link create(SpanContext spanContext) {
            return new AutoValue_SpanData_Link(spanContext, DEFAULT_ATTRIBUTE_COLLECTION, 0);
        }

        public static Link create(SpanContext spanContext, Attributes attributes) {
            return new AutoValue_SpanData_Link(spanContext, attributes, attributes.size());
        }

        public static Link create(SpanContext spanContext, Attributes attributes, int totalAttributeCount) {
            return new AutoValue_SpanData_Link(spanContext, attributes, totalAttributeCount);
        }

        public abstract int getTotalAttributeCount();

        Link() {
        }
    }
}

