/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.trace;

import io.opentelemetry.sdk.trace.ReadableSpan;
import io.opentelemetry.sdk.trace.SpanProcessor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;

public final class MultiSpanProcessor
implements SpanProcessor {
    private final List<SpanProcessor> spanProcessorsStart;
    private final List<SpanProcessor> spanProcessorsEnd;
    private final List<SpanProcessor> spanProcessorsAll;

    public static SpanProcessor create(List<SpanProcessor> spanProcessorList) {
        return new MultiSpanProcessor(new ArrayList<SpanProcessor>((Collection)Objects.requireNonNull(spanProcessorList, "spanProcessorList")));
    }

    @Override
    public void onStart(ReadableSpan readableSpan) {
        for (SpanProcessor spanProcessor : this.spanProcessorsStart) {
            spanProcessor.onStart(readableSpan);
        }
    }

    @Override
    public boolean isStartRequired() {
        return !this.spanProcessorsStart.isEmpty();
    }

    @Override
    public void onEnd(ReadableSpan readableSpan) {
        for (SpanProcessor spanProcessor : this.spanProcessorsEnd) {
            spanProcessor.onEnd(readableSpan);
        }
    }

    @Override
    public boolean isEndRequired() {
        return !this.spanProcessorsEnd.isEmpty();
    }

    @Override
    public void shutdown() {
        for (SpanProcessor spanProcessor : this.spanProcessorsAll) {
            spanProcessor.shutdown();
        }
    }

    @Override
    public void forceFlush() {
        for (SpanProcessor spanProcessor : this.spanProcessorsAll) {
            spanProcessor.forceFlush();
        }
    }

    private MultiSpanProcessor(List<SpanProcessor> spanProcessors) {
        this.spanProcessorsAll = spanProcessors;
        this.spanProcessorsStart = new ArrayList<SpanProcessor>(this.spanProcessorsAll.size());
        this.spanProcessorsEnd = new ArrayList<SpanProcessor>(this.spanProcessorsAll.size());
        for (SpanProcessor spanProcessor : this.spanProcessorsAll) {
            if (spanProcessor.isStartRequired()) {
                this.spanProcessorsStart.add(spanProcessor);
            }
            if (!spanProcessor.isEndRequired()) continue;
            this.spanProcessorsEnd.add(spanProcessor);
        }
    }
}

