/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.metrics.aggregator;

import io.opentelemetry.common.Labels;
import io.opentelemetry.sdk.metrics.aggregator.AbstractAggregator;
import io.opentelemetry.sdk.metrics.aggregator.Aggregator;
import io.opentelemetry.sdk.metrics.aggregator.AggregatorFactory;
import io.opentelemetry.sdk.metrics.data.MetricData;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nullable;

public final class LongLastValueAggregator
extends AbstractAggregator {
    @Nullable
    private static final Long DEFAULT_VALUE = null;
    private static final AggregatorFactory AGGREGATOR_FACTORY = new AggregatorFactory(){

        @Override
        public Aggregator getAggregator() {
            return new LongLastValueAggregator();
        }
    };
    private final AtomicReference<Long> current = new AtomicReference<Long>(DEFAULT_VALUE);

    public static AggregatorFactory getFactory() {
        return AGGREGATOR_FACTORY;
    }

    @Override
    void doMergeAndReset(Aggregator aggregator) {
        LongLastValueAggregator other = (LongLastValueAggregator)aggregator;
        other.current.set(this.current.getAndSet(DEFAULT_VALUE));
    }

    @Override
    @Nullable
    public MetricData.Point toPoint(long startEpochNanos, long epochNanos, Labels labels) {
        Long currentValue = this.current.get();
        return currentValue == null ? null : MetricData.LongPoint.create(startEpochNanos, epochNanos, labels, this.current.get());
    }

    @Override
    public void recordLong(long value) {
        this.current.set(value);
    }
}

