/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.trace;

import io.opentelemetry.sdk.common.Clock;
import io.opentelemetry.sdk.resources.Resource;
import io.opentelemetry.sdk.trace.IdsGenerator;
import io.opentelemetry.sdk.trace.MultiSpanProcessor;
import io.opentelemetry.sdk.trace.NoopSpanProcessor;
import io.opentelemetry.sdk.trace.SpanProcessor;
import io.opentelemetry.sdk.trace.config.TraceConfig;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.concurrent.GuardedBy;

final class TracerSharedState {
    private final Object lock = new Object();
    private final Clock clock;
    private final IdsGenerator idsGenerator;
    private final Resource resource;
    private volatile TraceConfig activeTraceConfig = TraceConfig.getDefault();
    private volatile SpanProcessor activeSpanProcessor = NoopSpanProcessor.getInstance();
    private volatile boolean isStopped = false;
    @GuardedBy(value="lock")
    private final List<SpanProcessor> registeredSpanProcessors = new ArrayList<SpanProcessor>();

    TracerSharedState(Clock clock, IdsGenerator idsGenerator, Resource resource) {
        this.clock = clock;
        this.idsGenerator = idsGenerator;
        this.resource = resource;
    }

    Clock getClock() {
        return this.clock;
    }

    IdsGenerator getIdsGenerator() {
        return this.idsGenerator;
    }

    Resource getResource() {
        return this.resource;
    }

    TraceConfig getActiveTraceConfig() {
        return this.activeTraceConfig;
    }

    void updateActiveTraceConfig(TraceConfig traceConfig) {
        this.activeTraceConfig = traceConfig;
    }

    SpanProcessor getActiveSpanProcessor() {
        return this.activeSpanProcessor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addSpanProcessor(SpanProcessor spanProcessor) {
        Object object = this.lock;
        synchronized (object) {
            this.registeredSpanProcessors.add(spanProcessor);
            this.activeSpanProcessor = MultiSpanProcessor.create(this.registeredSpanProcessors);
        }
    }

    boolean isStopped() {
        return this.isStopped;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void stop() {
        Object object = this.lock;
        synchronized (object) {
            if (this.isStopped) {
                return;
            }
            this.activeSpanProcessor.shutdown();
            this.isStopped = true;
        }
    }
}

