/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.trace;

import com.google.common.base.Preconditions;
import com.google.common.collect.EvictingQueue;
import io.opentelemetry.common.AttributeValue;
import io.opentelemetry.common.Attributes;
import io.opentelemetry.common.ReadableAttributes;
import io.opentelemetry.common.ReadableKeyValuePairs;
import io.opentelemetry.sdk.common.Clock;
import io.opentelemetry.sdk.common.InstrumentationLibraryInfo;
import io.opentelemetry.sdk.resources.Resource;
import io.opentelemetry.sdk.trace.AttributesMap;
import io.opentelemetry.sdk.trace.ReadableSpan;
import io.opentelemetry.sdk.trace.SpanProcessor;
import io.opentelemetry.sdk.trace.SpanWrapper;
import io.opentelemetry.sdk.trace.TimedEvent;
import io.opentelemetry.sdk.trace.config.TraceConfig;
import io.opentelemetry.sdk.trace.data.SpanData;
import io.opentelemetry.trace.EndSpanOptions;
import io.opentelemetry.trace.Event;
import io.opentelemetry.trace.Link;
import io.opentelemetry.trace.Span;
import io.opentelemetry.trace.SpanContext;
import io.opentelemetry.trace.SpanId;
import io.opentelemetry.trace.Status;
import io.opentelemetry.trace.Tracer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
final class RecordEventsReadableSpan
implements ReadableSpan,
Span {
    private static final Logger logger = Logger.getLogger(Tracer.class.getName());
    private final TraceConfig traceConfig;
    private final SpanContext context;
    private final SpanId parentSpanId;
    private final boolean hasRemoteParent;
    private final SpanProcessor spanProcessor;
    private final List<Link> links;
    private final int totalRecordedLinks;
    private final Object lock = new Object();
    @GuardedBy(value="lock")
    private String name;
    private final Span.Kind kind;
    private final Clock clock;
    private final Resource resource;
    private final InstrumentationLibraryInfo instrumentationLibraryInfo;
    private final long startEpochNanos;
    @Nullable
    @GuardedBy(value="lock")
    private AttributesMap attributes;
    @GuardedBy(value="lock")
    private final EvictingQueue<TimedEvent> events;
    @GuardedBy(value="lock")
    private int totalRecordedEvents = 0;
    @Nullable
    @GuardedBy(value="lock")
    private Status status;
    @GuardedBy(value="lock")
    private long endEpochNanos;
    @GuardedBy(value="lock")
    private boolean hasEnded;

    private RecordEventsReadableSpan(SpanContext context, String name, InstrumentationLibraryInfo instrumentationLibraryInfo, Span.Kind kind, SpanId parentSpanId, boolean hasRemoteParent, TraceConfig traceConfig, SpanProcessor spanProcessor, Clock clock, Resource resource, @Nullable AttributesMap attributes, List<Link> links, int totalRecordedLinks, long startEpochNanos) {
        this.context = context;
        this.instrumentationLibraryInfo = instrumentationLibraryInfo;
        this.parentSpanId = parentSpanId;
        this.hasRemoteParent = hasRemoteParent;
        this.links = links;
        this.totalRecordedLinks = totalRecordedLinks;
        this.name = name;
        this.kind = kind;
        this.spanProcessor = spanProcessor;
        this.resource = resource;
        this.hasEnded = false;
        this.clock = clock;
        this.startEpochNanos = startEpochNanos;
        this.attributes = attributes;
        this.events = EvictingQueue.create((int)traceConfig.getMaxNumberOfEvents());
        this.traceConfig = traceConfig;
    }

    static RecordEventsReadableSpan startSpan(SpanContext context, String name, InstrumentationLibraryInfo instrumentationLibraryInfo, Span.Kind kind, @Nullable SpanId parentSpanId, boolean hasRemoteParent, TraceConfig traceConfig, SpanProcessor spanProcessor, Clock clock, Resource resource, AttributesMap attributes, List<Link> links, int totalRecordedLinks, long startEpochNanos) {
        RecordEventsReadableSpan span = new RecordEventsReadableSpan(context, name, instrumentationLibraryInfo, kind, parentSpanId == null ? SpanId.getInvalid() : parentSpanId, hasRemoteParent, traceConfig, spanProcessor, clock, resource, attributes, links, totalRecordedLinks, startEpochNanos == 0L ? clock.now() : startEpochNanos);
        spanProcessor.onStart(span);
        return span;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SpanData toSpanData() {
        Object object = this.lock;
        synchronized (object) {
            return SpanWrapper.create(this, this.getImmutableLinks(), this.getImmutableTimedEvents(), this.getImmutableAttributes(), this.attributes == null ? 0 : this.attributes.getTotalAddedValues(), this.totalRecordedEvents, this.getStatusWithDefault());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasEnded() {
        Object object = this.lock;
        synchronized (object) {
            return this.hasEnded;
        }
    }

    @Override
    public SpanContext getSpanContext() {
        return this.getContext();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getName() {
        Object object = this.lock;
        synchronized (object) {
            return this.name;
        }
    }

    @Override
    public InstrumentationLibraryInfo getInstrumentationLibraryInfo() {
        return this.instrumentationLibraryInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long getEndEpochNanos() {
        Object object = this.lock;
        synchronized (object) {
            return this.endEpochNanos;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getLatencyNanos() {
        Object object = this.lock;
        synchronized (object) {
            return (this.hasEnded ? this.endEpochNanos : this.clock.now()) - this.startEpochNanos;
        }
    }

    Clock getClock() {
        return this.clock;
    }

    public void setAttribute(String key, String value) {
        this.setAttribute(key, AttributeValue.stringAttributeValue((String)value));
    }

    public void setAttribute(String key, long value) {
        this.setAttribute(key, AttributeValue.longAttributeValue((long)value));
    }

    public void setAttribute(String key, double value) {
        this.setAttribute(key, AttributeValue.doubleAttributeValue((double)value));
    }

    public void setAttribute(String key, boolean value) {
        this.setAttribute(key, AttributeValue.booleanAttributeValue((boolean)value));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAttribute(String key, AttributeValue value) {
        Preconditions.checkNotNull((Object)key, (Object)"key");
        Object object = this.lock;
        synchronized (object) {
            if (this.hasEnded) {
                logger.log(Level.FINE, "Calling setAttribute() on an ended Span.");
                return;
            }
            if (value == null || value.getType().equals((Object)AttributeValue.Type.STRING) && value.getStringValue() == null) {
                if (this.attributes == null) {
                    return;
                }
                this.attributes.remove(key);
                return;
            }
            if (this.attributes == null) {
                this.attributes = new AttributesMap((long)this.traceConfig.getMaxNumberOfAttributes());
            }
            this.attributes.put(key, value);
        }
    }

    public void addEvent(String name) {
        this.addTimedEvent(TimedEvent.create(this.clock.now(), name, Attributes.empty(), 0));
    }

    public void addEvent(String name, long timestamp) {
        this.addTimedEvent(TimedEvent.create(timestamp, name, Attributes.empty(), 0));
    }

    public void addEvent(String name, Attributes attributes) {
        int totalAttributeCount = attributes.size();
        this.addTimedEvent(TimedEvent.create(this.clock.now(), name, RecordEventsReadableSpan.copyAndLimitAttributes(attributes, this.traceConfig.getMaxNumberOfAttributesPerEvent()), totalAttributeCount));
    }

    public void addEvent(String name, Attributes attributes, long timestamp) {
        int totalAttributeCount = attributes.size();
        this.addTimedEvent(TimedEvent.create(timestamp, name, RecordEventsReadableSpan.copyAndLimitAttributes(attributes, this.traceConfig.getMaxNumberOfAttributesPerEvent()), totalAttributeCount));
    }

    public void addEvent(Event event) {
        this.addTimedEvent(TimedEvent.create(this.clock.now(), event));
    }

    public void addEvent(Event event, long timestamp) {
        this.addTimedEvent(TimedEvent.create(timestamp, event));
    }

    static Attributes copyAndLimitAttributes(Attributes attributes, int limit) {
        if (attributes.isEmpty() || attributes.size() <= limit) {
            return attributes;
        }
        Attributes.Builder result = Attributes.newBuilder();
        attributes.forEach((ReadableKeyValuePairs.KeyValueConsumer)new LimitingAttributeConsumer(limit, result));
        return result.build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addTimedEvent(TimedEvent timedEvent) {
        Object object = this.lock;
        synchronized (object) {
            if (this.hasEnded) {
                logger.log(Level.FINE, "Calling addEvent() on an ended Span.");
                return;
            }
            this.events.add((Object)timedEvent);
            ++this.totalRecordedEvents;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setStatus(Status status) {
        Preconditions.checkNotNull((Object)status, (Object)"status");
        Object object = this.lock;
        synchronized (object) {
            if (this.hasEnded) {
                logger.log(Level.FINE, "Calling setStatus() on an ended Span.");
                return;
            }
            this.status = status;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateName(String name) {
        Preconditions.checkNotNull((Object)name, (Object)"name");
        Object object = this.lock;
        synchronized (object) {
            if (this.hasEnded) {
                logger.log(Level.FINE, "Calling updateName() on an ended Span.");
                return;
            }
            this.name = name;
        }
    }

    public void end() {
        this.endInternal(this.clock.now());
    }

    public void end(EndSpanOptions endOptions) {
        Preconditions.checkNotNull((Object)endOptions, (Object)"endOptions");
        this.endInternal(endOptions.getEndTimestamp() == 0L ? this.clock.now() : endOptions.getEndTimestamp());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void endInternal(long endEpochNanos) {
        Object object = this.lock;
        synchronized (object) {
            if (this.hasEnded) {
                logger.log(Level.FINE, "Calling end() on an ended Span.");
                return;
            }
            this.endEpochNanos = endEpochNanos;
            this.hasEnded = true;
        }
        this.spanProcessor.onEnd(this);
    }

    public SpanContext getContext() {
        return this.context;
    }

    public boolean isRecording() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GuardedBy(value="lock")
    private Status getStatusWithDefault() {
        Object object = this.lock;
        synchronized (object) {
            return this.status == null ? Status.OK : this.status;
        }
    }

    SpanId getParentSpanId() {
        return this.parentSpanId;
    }

    Resource getResource() {
        return this.resource;
    }

    Span.Kind getKind() {
        return this.kind;
    }

    long getStartEpochNanos() {
        return this.startEpochNanos;
    }

    boolean hasRemoteParent() {
        return this.hasRemoteParent;
    }

    int getTotalRecordedLinks() {
        return this.totalRecordedLinks;
    }

    @GuardedBy(value="lock")
    private List<SpanData.Link> getImmutableLinks() {
        if (this.links.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<SpanData.Link> result = new ArrayList<SpanData.Link>(this.links.size());
        for (Link link : this.links) {
            SpanData.Link newLink = !(link instanceof SpanData.Link) ? SpanData.Link.create(link.getContext(), link.getAttributes()) : (SpanData.Link)link;
            result.add(newLink);
        }
        return Collections.unmodifiableList(result);
    }

    @GuardedBy(value="lock")
    private List<SpanData.Event> getImmutableTimedEvents() {
        if (this.events.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<TimedEvent> results = new ArrayList<TimedEvent>(this.events.size());
        for (TimedEvent event : this.events) {
            if (event instanceof TimedEvent.RawTimedEventWithEvent) {
                results.add(TimedEvent.create(event.getEpochNanos(), event.getName(), event.getAttributes(), event.getTotalAttributeCount()));
                continue;
            }
            results.add(event);
        }
        return Collections.unmodifiableList(results);
    }

    @GuardedBy(value="lock")
    private ReadableAttributes getImmutableAttributes() {
        if (this.attributes == null || this.attributes.isEmpty()) {
            return Attributes.empty();
        }
        if (this.hasEnded) {
            return this.attributes;
        }
        Attributes.Builder builder = Attributes.newBuilder();
        for (Map.Entry entry : this.attributes.entrySet()) {
            builder.setAttribute((String)entry.getKey(), (AttributeValue)entry.getValue());
        }
        return builder.build();
    }

    private static class LimitingAttributeConsumer
    implements ReadableKeyValuePairs.KeyValueConsumer<AttributeValue> {
        private final int limit;
        private final Attributes.Builder builder;
        private int added;

        public LimitingAttributeConsumer(int limit, Attributes.Builder builder) {
            this.limit = limit;
            this.builder = builder;
        }

        public void consume(String key, AttributeValue value) {
            if (this.added < this.limit) {
                this.builder.setAttribute(key, value);
                ++this.added;
            }
        }
    }
}

