/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.metrics.view;

import io.opentelemetry.sdk.metrics.aggregator.AggregatorFactory;
import io.opentelemetry.sdk.metrics.aggregator.DoubleLastValueAggregator;
import io.opentelemetry.sdk.metrics.aggregator.DoubleMinMaxSumCount;
import io.opentelemetry.sdk.metrics.aggregator.DoubleSumAggregator;
import io.opentelemetry.sdk.metrics.aggregator.LongLastValueAggregator;
import io.opentelemetry.sdk.metrics.aggregator.LongMinMaxSumCount;
import io.opentelemetry.sdk.metrics.aggregator.LongSumAggregator;
import io.opentelemetry.sdk.metrics.aggregator.NoopAggregator;
import io.opentelemetry.sdk.metrics.common.InstrumentType;
import io.opentelemetry.sdk.metrics.common.InstrumentValueType;
import io.opentelemetry.sdk.metrics.data.MetricData;
import io.opentelemetry.sdk.metrics.view.Aggregation;
import javax.annotation.concurrent.Immutable;

public class Aggregations {
    public static Aggregation sum() {
        return Sum.INSTANCE;
    }

    public static Aggregation count() {
        return Count.INSTANCE;
    }

    public static Aggregation distributionWithExplicitBounds(Double ... bucketBoundaries) {
        return new Distribution(bucketBoundaries);
    }

    public static Aggregation lastValue() {
        return LastValue.INSTANCE;
    }

    public static Aggregation minMaxSumCount() {
        return MinMaxSumCount.INSTANCE;
    }

    private Aggregations() {
    }

    @Immutable
    private static enum LastValue implements Aggregation
    {
        INSTANCE;


        @Override
        public AggregatorFactory getAggregatorFactory(InstrumentValueType instrumentValueType) {
            return instrumentValueType == InstrumentValueType.LONG ? LongLastValueAggregator.getFactory() : DoubleLastValueAggregator.getFactory();
        }

        @Override
        public MetricData.Descriptor.Type getDescriptorType(InstrumentType instrumentType, InstrumentValueType instrumentValueType) {
            switch (instrumentType) {
                case SUM_OBSERVER: {
                    return instrumentValueType == InstrumentValueType.LONG ? MetricData.Descriptor.Type.MONOTONIC_LONG : MetricData.Descriptor.Type.MONOTONIC_DOUBLE;
                }
                case UP_DOWN_SUM_OBSERVER: {
                    return instrumentValueType == InstrumentValueType.LONG ? MetricData.Descriptor.Type.NON_MONOTONIC_LONG : MetricData.Descriptor.Type.NON_MONOTONIC_DOUBLE;
                }
            }
            throw new IllegalArgumentException("Unsupported instrument/value types");
        }

        @Override
        public String getUnit(String initialUnit) {
            return initialUnit;
        }

        @Override
        public boolean availableForInstrument(InstrumentType instrumentType) {
            return instrumentType == InstrumentType.SUM_OBSERVER || instrumentType == InstrumentType.UP_DOWN_SUM_OBSERVER;
        }
    }

    @Immutable
    private static final class Distribution
    implements Aggregation {
        private final AggregatorFactory factory = NoopAggregator.getFactory();

        Distribution(Double ... bucketBoundaries) {
        }

        @Override
        public AggregatorFactory getAggregatorFactory(InstrumentValueType instrumentValueType) {
            return this.factory;
        }

        @Override
        public MetricData.Descriptor.Type getDescriptorType(InstrumentType instrumentType, InstrumentValueType instrumentValueType) {
            throw new UnsupportedOperationException("Implement this");
        }

        @Override
        public String getUnit(String initialUnit) {
            return initialUnit;
        }

        @Override
        public boolean availableForInstrument(InstrumentType instrumentType) {
            throw new UnsupportedOperationException("Implement this");
        }
    }

    @Immutable
    private static enum Count implements Aggregation
    {
        INSTANCE;


        @Override
        public AggregatorFactory getAggregatorFactory(InstrumentValueType instrumentValueType) {
            return NoopAggregator.getFactory();
        }

        @Override
        public MetricData.Descriptor.Type getDescriptorType(InstrumentType instrumentType, InstrumentValueType instrumentValueType) {
            return MetricData.Descriptor.Type.MONOTONIC_LONG;
        }

        @Override
        public String getUnit(String initialUnit) {
            return "1";
        }

        @Override
        public boolean availableForInstrument(InstrumentType instrumentType) {
            return true;
        }
    }

    @Immutable
    private static enum Sum implements Aggregation
    {
        INSTANCE;


        @Override
        public AggregatorFactory getAggregatorFactory(InstrumentValueType instrumentValueType) {
            return instrumentValueType == InstrumentValueType.LONG ? LongSumAggregator.getFactory() : DoubleSumAggregator.getFactory();
        }

        @Override
        public MetricData.Descriptor.Type getDescriptorType(InstrumentType instrumentType, InstrumentValueType instrumentValueType) {
            switch (instrumentType) {
                case COUNTER: 
                case SUM_OBSERVER: {
                    return instrumentValueType == InstrumentValueType.LONG ? MetricData.Descriptor.Type.MONOTONIC_LONG : MetricData.Descriptor.Type.MONOTONIC_DOUBLE;
                }
                case UP_DOWN_COUNTER: 
                case VALUE_RECORDER: 
                case UP_DOWN_SUM_OBSERVER: 
                case VALUE_OBSERVER: {
                    return instrumentValueType == InstrumentValueType.LONG ? MetricData.Descriptor.Type.NON_MONOTONIC_LONG : MetricData.Descriptor.Type.NON_MONOTONIC_DOUBLE;
                }
            }
            throw new IllegalArgumentException("Unsupported instrument/value types");
        }

        @Override
        public String getUnit(String initialUnit) {
            return initialUnit;
        }

        @Override
        public boolean availableForInstrument(InstrumentType instrumentType) {
            return true;
        }
    }

    private static enum MinMaxSumCount implements Aggregation
    {
        INSTANCE;


        @Override
        public AggregatorFactory getAggregatorFactory(InstrumentValueType instrumentValueType) {
            return instrumentValueType == InstrumentValueType.LONG ? LongMinMaxSumCount.getFactory() : DoubleMinMaxSumCount.getFactory();
        }

        @Override
        public MetricData.Descriptor.Type getDescriptorType(InstrumentType instrumentType, InstrumentValueType instrumentValueType) {
            return MetricData.Descriptor.Type.SUMMARY;
        }

        @Override
        public String getUnit(String initialUnit) {
            return initialUnit;
        }

        @Override
        public boolean availableForInstrument(InstrumentType instrumentType) {
            return instrumentType == InstrumentType.VALUE_OBSERVER || instrumentType == InstrumentType.VALUE_RECORDER;
        }
    }
}

