/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.metrics.data;

import io.opentelemetry.common.Labels;
import io.opentelemetry.sdk.metrics.data.MetricData;
import java.util.List;

final class AutoValue_MetricData_SummaryPoint
extends MetricData.SummaryPoint {
    private final long startEpochNanos;
    private final long epochNanos;
    private final Labels labels;
    private final long count;
    private final double sum;
    private final List<MetricData.ValueAtPercentile> percentileValues;

    AutoValue_MetricData_SummaryPoint(long startEpochNanos, long epochNanos, Labels labels, long count, double sum, List<MetricData.ValueAtPercentile> percentileValues) {
        this.startEpochNanos = startEpochNanos;
        this.epochNanos = epochNanos;
        if (labels == null) {
            throw new NullPointerException("Null labels");
        }
        this.labels = labels;
        this.count = count;
        this.sum = sum;
        if (percentileValues == null) {
            throw new NullPointerException("Null percentileValues");
        }
        this.percentileValues = percentileValues;
    }

    @Override
    public long getStartEpochNanos() {
        return this.startEpochNanos;
    }

    @Override
    public long getEpochNanos() {
        return this.epochNanos;
    }

    @Override
    public Labels getLabels() {
        return this.labels;
    }

    @Override
    public long getCount() {
        return this.count;
    }

    @Override
    public double getSum() {
        return this.sum;
    }

    @Override
    public List<MetricData.ValueAtPercentile> getPercentileValues() {
        return this.percentileValues;
    }

    public String toString() {
        return "SummaryPoint{startEpochNanos=" + this.startEpochNanos + ", epochNanos=" + this.epochNanos + ", labels=" + this.labels + ", count=" + this.count + ", sum=" + this.sum + ", percentileValues=" + this.percentileValues + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof MetricData.SummaryPoint) {
            MetricData.SummaryPoint that = (MetricData.SummaryPoint)o;
            return this.startEpochNanos == that.getStartEpochNanos() && this.epochNanos == that.getEpochNanos() && this.labels.equals(that.getLabels()) && this.count == that.getCount() && Double.doubleToLongBits(this.sum) == Double.doubleToLongBits(that.getSum()) && this.percentileValues.equals(that.getPercentileValues());
        }
        return false;
    }

    public int hashCode() {
        int h$ = 1;
        h$ *= 1000003;
        h$ ^= (int)(this.startEpochNanos >>> 32 ^ this.startEpochNanos);
        h$ *= 1000003;
        h$ ^= (int)(this.epochNanos >>> 32 ^ this.epochNanos);
        h$ *= 1000003;
        h$ ^= this.labels.hashCode();
        h$ *= 1000003;
        h$ ^= (int)(this.count >>> 32 ^ this.count);
        h$ *= 1000003;
        h$ ^= (int)(Double.doubleToLongBits(this.sum) >>> 32 ^ Double.doubleToLongBits(this.sum));
        h$ *= 1000003;
        return h$ ^= this.percentileValues.hashCode();
    }
}

