/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.trace;

import io.opentelemetry.context.Scope;
import io.opentelemetry.sdk.common.InstrumentationLibraryInfo;
import io.opentelemetry.sdk.trace.SpanBuilderSdk;
import io.opentelemetry.sdk.trace.TracerSharedState;
import io.opentelemetry.trace.DefaultTracer;
import io.opentelemetry.trace.Span;
import io.opentelemetry.trace.Tracer;
import io.opentelemetry.trace.TracingContextUtils;

final class TracerSdk
implements Tracer {
    private final TracerSharedState sharedState;
    private final InstrumentationLibraryInfo instrumentationLibraryInfo;

    TracerSdk(TracerSharedState sharedState, InstrumentationLibraryInfo instrumentationLibraryInfo) {
        this.sharedState = sharedState;
        this.instrumentationLibraryInfo = instrumentationLibraryInfo;
    }

    public Span getCurrentSpan() {
        return TracingContextUtils.getCurrentSpan();
    }

    public Scope withSpan(Span span) {
        return TracingContextUtils.currentContextWith((Span)span);
    }

    public Span.Builder spanBuilder(String spanName) {
        if (this.sharedState.isStopped()) {
            return DefaultTracer.getInstance().spanBuilder(spanName);
        }
        return new SpanBuilderSdk(spanName, this.instrumentationLibraryInfo, this.sharedState.getActiveSpanProcessor(), this.sharedState.getActiveTraceConfig(), this.sharedState.getResource(), this.sharedState.getIdsGenerator(), this.sharedState.getClock());
    }

    InstrumentationLibraryInfo getInstrumentationLibraryInfo() {
        return this.instrumentationLibraryInfo;
    }
}

