/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.trace;

import io.opentelemetry.common.AttributeValue;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;

final class AttributesMap
extends HashMap<String, AttributeValue> {
    private final long capacity;
    private int totalAddedValues = 0;
    private static final long serialVersionUID = 42L;

    AttributesMap(long capacity) {
        this.capacity = capacity;
    }

    @Override
    @Nullable
    public AttributeValue put(String key, AttributeValue value) {
        ++this.totalAddedValues;
        if ((long)this.size() >= this.capacity && !this.containsKey(key)) {
            return null;
        }
        return super.put(key, value);
    }

    @Override
    public void putAll(Map<? extends String, ? extends AttributeValue> values) {
        for (Map.Entry<? extends String, ? extends AttributeValue> entry : values.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    @Nullable
    public AttributeValue remove(Object key) {
        return (AttributeValue)super.remove(key);
    }

    @Override
    public AttributeValue putIfAbsent(String key, AttributeValue value) {
        throw new UnsupportedOperationException("Do not call methods on the map");
    }

    @Override
    public AttributeValue replace(String key, AttributeValue value) {
        throw new UnsupportedOperationException("Do not call methods on the map");
    }

    @Override
    public boolean replace(String key, AttributeValue oldValue, AttributeValue newValue) {
        throw new UnsupportedOperationException("Do not call methods on the map");
    }

    int getTotalAddedValues() {
        return this.totalAddedValues;
    }
}

