/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.metrics;

import io.opentelemetry.metrics.DoubleValueRecorder;
import io.opentelemetry.sdk.metrics.AbstractBoundInstrument;
import io.opentelemetry.sdk.metrics.AbstractInstrument;
import io.opentelemetry.sdk.metrics.AbstractSynchronousInstrument;
import io.opentelemetry.sdk.metrics.ActiveBatcher;
import io.opentelemetry.sdk.metrics.Batcher;
import io.opentelemetry.sdk.metrics.Batchers;
import io.opentelemetry.sdk.metrics.InstrumentDescriptor;
import io.opentelemetry.sdk.metrics.LabelSetSdk;
import io.opentelemetry.sdk.metrics.MeterProviderSharedState;
import io.opentelemetry.sdk.metrics.MeterSharedState;
import io.opentelemetry.sdk.metrics.common.InstrumentType;
import io.opentelemetry.sdk.metrics.common.InstrumentValueType;
import io.opentelemetry.sdk.metrics.view.Aggregations;

final class DoubleValueRecorderSdk
extends AbstractSynchronousInstrument<BoundInstrument>
implements DoubleValueRecorder {
    private DoubleValueRecorderSdk(InstrumentDescriptor descriptor, MeterProviderSharedState meterProviderSharedState, MeterSharedState meterSharedState) {
        super(descriptor, meterProviderSharedState, meterSharedState, new ActiveBatcher(Batchers.getCumulativeAllLabels(descriptor, meterProviderSharedState, meterSharedState, Aggregations.minMaxSumCount())));
    }

    public void record(double delta, String ... labelKeyValuePairs) {
        this.record(delta, LabelSetSdk.create(labelKeyValuePairs));
    }

    void record(double value, LabelSetSdk labelSet) {
        BoundInstrument boundInstrument = (BoundInstrument)this.bind(labelSet);
        boundInstrument.record(value);
        boundInstrument.unbind();
    }

    public BoundInstrument bind(String ... labelKeyValuePairs) {
        return (BoundInstrument)this.bind(LabelSetSdk.create(labelKeyValuePairs));
    }

    @Override
    BoundInstrument newBinding(Batcher batcher) {
        return new BoundInstrument(batcher);
    }

    static final class Builder
    extends AbstractInstrument.Builder<Builder>
    implements DoubleValueRecorder.Builder {
        Builder(String name, MeterProviderSharedState meterProviderSharedState, MeterSharedState meterSharedState) {
            super(name, meterProviderSharedState, meterSharedState);
        }

        @Override
        Builder getThis() {
            return this;
        }

        public DoubleValueRecorderSdk build() {
            return this.register(new DoubleValueRecorderSdk(this.getInstrumentDescriptor(InstrumentType.VALUE_RECORDER, InstrumentValueType.DOUBLE), this.getMeterProviderSharedState(), this.getMeterSharedState()));
        }
    }

    static final class BoundInstrument
    extends AbstractBoundInstrument
    implements DoubleValueRecorder.BoundDoubleValueRecorder {
        BoundInstrument(Batcher batcher) {
            super(batcher.getAggregator());
        }

        public void record(double value) {
            this.recordDouble(value);
        }
    }
}

