/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.metrics;

import io.opentelemetry.metrics.DoubleValueObserver;
import io.opentelemetry.sdk.metrics.AbstractAsynchronousInstrument;
import io.opentelemetry.sdk.metrics.ActiveBatcher;
import io.opentelemetry.sdk.metrics.Batchers;
import io.opentelemetry.sdk.metrics.InstrumentDescriptor;
import io.opentelemetry.sdk.metrics.LabelSetSdk;
import io.opentelemetry.sdk.metrics.MeterProviderSharedState;
import io.opentelemetry.sdk.metrics.MeterSharedState;
import io.opentelemetry.sdk.metrics.aggregator.Aggregator;
import io.opentelemetry.sdk.metrics.common.InstrumentType;
import io.opentelemetry.sdk.metrics.common.InstrumentValueType;
import io.opentelemetry.sdk.metrics.view.Aggregations;

final class DoubleValueObserverSdk
extends AbstractAsynchronousInstrument<DoubleValueObserver.ResultDoubleValueObserver>
implements DoubleValueObserver {
    DoubleValueObserverSdk(InstrumentDescriptor descriptor, MeterProviderSharedState meterProviderSharedState, MeterSharedState meterSharedState) {
        super(descriptor, meterProviderSharedState, meterSharedState, new ActiveBatcher(Batchers.getDeltaAllLabels(descriptor, meterProviderSharedState, meterSharedState, Aggregations.minMaxSumCount())));
    }

    @Override
    DoubleValueObserver.ResultDoubleValueObserver newResult(ActiveBatcher activeBatcher) {
        return new ResultDoubleValueObserverSdk(activeBatcher);
    }

    private static final class ResultDoubleValueObserverSdk
    implements DoubleValueObserver.ResultDoubleValueObserver {
        private final ActiveBatcher activeBatcher;

        private ResultDoubleValueObserverSdk(ActiveBatcher activeBatcher) {
            this.activeBatcher = activeBatcher;
        }

        public void observe(double sum, String ... keyValueLabelPairs) {
            Aggregator aggregator = this.activeBatcher.getAggregator();
            aggregator.recordDouble(sum);
            this.activeBatcher.batch(LabelSetSdk.create(keyValueLabelPairs), aggregator, false);
        }
    }

    static final class Builder
    extends AbstractAsynchronousInstrument.Builder<Builder>
    implements DoubleValueObserver.Builder {
        Builder(String name, MeterProviderSharedState meterProviderSharedState, MeterSharedState meterSharedState) {
            super(name, meterProviderSharedState, meterSharedState);
        }

        @Override
        Builder getThis() {
            return this;
        }

        public DoubleValueObserverSdk build() {
            return this.register(new DoubleValueObserverSdk(this.getInstrumentDescriptor(InstrumentType.VALUE_OBSERVER, InstrumentValueType.DOUBLE), this.getMeterProviderSharedState(), this.getMeterSharedState()));
        }
    }
}

