/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.trace.config;

import com.google.auto.value.AutoValue;
import com.google.common.base.Preconditions;
import io.opentelemetry.sdk.trace.Sampler;
import io.opentelemetry.sdk.trace.Samplers;
import io.opentelemetry.sdk.trace.config.AutoValue_TraceConfig;
import javax.annotation.concurrent.Immutable;

@AutoValue
@Immutable
public abstract class TraceConfig {
    private static final Sampler DEFAULT_SAMPLER = Samplers.alwaysOn();
    private static final int DEFAULT_SPAN_MAX_NUM_ATTRIBUTES = 32;
    private static final int DEFAULT_SPAN_MAX_NUM_EVENTS = 128;
    private static final int DEFAULT_SPAN_MAX_NUM_LINKS = 32;
    private static final int DEFAULT_SPAN_MAX_NUM_ATTRIBUTES_PER_EVENT = 32;
    private static final int DEFAULT_SPAN_MAX_NUM_ATTRIBUTES_PER_LINK = 32;
    private static final TraceConfig DEFAULT = TraceConfig.newBuilder().setSampler(DEFAULT_SAMPLER).setMaxNumberOfAttributes(32).setMaxNumberOfEvents(128).setMaxNumberOfLinks(32).setMaxNumberOfAttributesPerEvent(32).setMaxNumberOfAttributesPerLink(32).build();

    public static TraceConfig getDefault() {
        return DEFAULT;
    }

    public abstract Sampler getSampler();

    public abstract int getMaxNumberOfAttributes();

    public abstract int getMaxNumberOfEvents();

    public abstract int getMaxNumberOfLinks();

    public abstract int getMaxNumberOfAttributesPerEvent();

    public abstract int getMaxNumberOfAttributesPerLink();

    private static Builder newBuilder() {
        return new AutoValue_TraceConfig.Builder();
    }

    public abstract Builder toBuilder();

    @AutoValue.Builder
    public static abstract class Builder {
        public abstract Builder setSampler(Sampler var1);

        public abstract Builder setMaxNumberOfAttributes(int var1);

        public abstract Builder setMaxNumberOfEvents(int var1);

        public abstract Builder setMaxNumberOfLinks(int var1);

        public abstract Builder setMaxNumberOfAttributesPerEvent(int var1);

        public abstract Builder setMaxNumberOfAttributesPerLink(int var1);

        abstract TraceConfig autoBuild();

        public TraceConfig build() {
            TraceConfig traceConfig = this.autoBuild();
            Preconditions.checkArgument((traceConfig.getMaxNumberOfAttributes() > 0 ? 1 : 0) != 0, (Object)"maxNumberOfAttributes");
            Preconditions.checkArgument((traceConfig.getMaxNumberOfEvents() > 0 ? 1 : 0) != 0, (Object)"maxNumberOfEvents");
            Preconditions.checkArgument((traceConfig.getMaxNumberOfLinks() > 0 ? 1 : 0) != 0, (Object)"maxNumberOfLinks");
            Preconditions.checkArgument((traceConfig.getMaxNumberOfAttributesPerEvent() > 0 ? 1 : 0) != 0, (Object)"maxNumberOfAttributesPerEvent");
            Preconditions.checkArgument((traceConfig.getMaxNumberOfAttributesPerLink() > 0 ? 1 : 0) != 0, (Object)"maxNumberOfAttributesPerLink");
            return traceConfig;
        }
    }
}

