/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.trace;

import io.opentelemetry.sdk.common.Clock;
import io.opentelemetry.sdk.common.InstrumentationLibraryInfo;
import io.opentelemetry.sdk.internal.ComponentRegistry;
import io.opentelemetry.sdk.internal.MillisClock;
import io.opentelemetry.sdk.resources.EnvVarResource;
import io.opentelemetry.sdk.resources.Resource;
import io.opentelemetry.sdk.trace.IdsGenerator;
import io.opentelemetry.sdk.trace.RandomIdsGenerator;
import io.opentelemetry.sdk.trace.SpanProcessor;
import io.opentelemetry.sdk.trace.TracerSdk;
import io.opentelemetry.sdk.trace.TracerSharedState;
import io.opentelemetry.sdk.trace.config.TraceConfig;
import io.opentelemetry.trace.TracerProvider;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;

public class TracerSdkProvider
implements TracerProvider {
    private static final Logger logger = Logger.getLogger(TracerProvider.class.getName());
    private final TracerSharedState sharedState;
    private final TracerSdkComponentRegistry tracerSdkComponentRegistry;

    public static Builder builder() {
        return new Builder();
    }

    private TracerSdkProvider(Clock clock, IdsGenerator idsGenerator, Resource resource) {
        this.sharedState = new TracerSharedState(clock, idsGenerator, resource);
        this.tracerSdkComponentRegistry = new TracerSdkComponentRegistry(this.sharedState);
    }

    public TracerSdk get(String instrumentationName) {
        return (TracerSdk)this.tracerSdkComponentRegistry.get(instrumentationName);
    }

    public TracerSdk get(String instrumentationName, String instrumentationVersion) {
        return (TracerSdk)this.tracerSdkComponentRegistry.get(instrumentationName, instrumentationVersion);
    }

    public TraceConfig getActiveTraceConfig() {
        return this.sharedState.getActiveTraceConfig();
    }

    public void updateActiveTraceConfig(TraceConfig traceConfig) {
        this.sharedState.updateActiveTraceConfig(traceConfig);
    }

    public void addSpanProcessor(SpanProcessor spanProcessor) {
        this.sharedState.addSpanProcessor(spanProcessor);
    }

    public void shutdown() {
        if (this.sharedState.isStopped()) {
            logger.log(Level.WARNING, "Calling shutdown() multiple times.");
            return;
        }
        this.sharedState.stop();
    }

    public void forceFlush() {
        this.sharedState.getActiveSpanProcessor().forceFlush();
    }

    private static final class TracerSdkComponentRegistry
    extends ComponentRegistry<TracerSdk> {
        private final TracerSharedState sharedState;

        private TracerSdkComponentRegistry(TracerSharedState sharedState) {
            this.sharedState = sharedState;
        }

        @Override
        public TracerSdk newComponent(InstrumentationLibraryInfo instrumentationLibraryInfo) {
            return new TracerSdk(this.sharedState, instrumentationLibraryInfo);
        }
    }

    public static class Builder {
        private Clock clock = MillisClock.getInstance();
        private IdsGenerator idsGenerator = new RandomIdsGenerator();
        private Resource resource = EnvVarResource.getResource();

        public Builder setClock(Clock clock) {
            Objects.requireNonNull(clock, "clock");
            this.clock = clock;
            return this;
        }

        public Builder setIdsGenerator(IdsGenerator idsGenerator) {
            Objects.requireNonNull(idsGenerator, "idsGenerator");
            this.idsGenerator = idsGenerator;
            return this;
        }

        public Builder setResource(Resource resource) {
            Objects.requireNonNull(resource, "resource");
            this.resource = resource;
            return this;
        }

        public TracerSdkProvider build() {
            return new TracerSdkProvider(this.clock, this.idsGenerator, this.resource);
        }

        private Builder() {
        }
    }
}

