/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.trace.config;

import io.opentelemetry.sdk.trace.Sampler;
import io.opentelemetry.sdk.trace.config.TraceConfig;

final class AutoValue_TraceConfig
extends TraceConfig {
    private final Sampler sampler;
    private final int maxNumberOfAttributes;
    private final int maxNumberOfEvents;
    private final int maxNumberOfLinks;
    private final int maxNumberOfAttributesPerEvent;
    private final int maxNumberOfAttributesPerLink;

    private AutoValue_TraceConfig(Sampler sampler, int maxNumberOfAttributes, int maxNumberOfEvents, int maxNumberOfLinks, int maxNumberOfAttributesPerEvent, int maxNumberOfAttributesPerLink) {
        this.sampler = sampler;
        this.maxNumberOfAttributes = maxNumberOfAttributes;
        this.maxNumberOfEvents = maxNumberOfEvents;
        this.maxNumberOfLinks = maxNumberOfLinks;
        this.maxNumberOfAttributesPerEvent = maxNumberOfAttributesPerEvent;
        this.maxNumberOfAttributesPerLink = maxNumberOfAttributesPerLink;
    }

    @Override
    public Sampler getSampler() {
        return this.sampler;
    }

    @Override
    public int getMaxNumberOfAttributes() {
        return this.maxNumberOfAttributes;
    }

    @Override
    public int getMaxNumberOfEvents() {
        return this.maxNumberOfEvents;
    }

    @Override
    public int getMaxNumberOfLinks() {
        return this.maxNumberOfLinks;
    }

    @Override
    public int getMaxNumberOfAttributesPerEvent() {
        return this.maxNumberOfAttributesPerEvent;
    }

    @Override
    public int getMaxNumberOfAttributesPerLink() {
        return this.maxNumberOfAttributesPerLink;
    }

    public String toString() {
        return "TraceConfig{sampler=" + this.sampler + ", maxNumberOfAttributes=" + this.maxNumberOfAttributes + ", maxNumberOfEvents=" + this.maxNumberOfEvents + ", maxNumberOfLinks=" + this.maxNumberOfLinks + ", maxNumberOfAttributesPerEvent=" + this.maxNumberOfAttributesPerEvent + ", maxNumberOfAttributesPerLink=" + this.maxNumberOfAttributesPerLink + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof TraceConfig) {
            TraceConfig that = (TraceConfig)o;
            return this.sampler.equals(that.getSampler()) && this.maxNumberOfAttributes == that.getMaxNumberOfAttributes() && this.maxNumberOfEvents == that.getMaxNumberOfEvents() && this.maxNumberOfLinks == that.getMaxNumberOfLinks() && this.maxNumberOfAttributesPerEvent == that.getMaxNumberOfAttributesPerEvent() && this.maxNumberOfAttributesPerLink == that.getMaxNumberOfAttributesPerLink();
        }
        return false;
    }

    public int hashCode() {
        int h$ = 1;
        h$ *= 1000003;
        h$ ^= this.sampler.hashCode();
        h$ *= 1000003;
        h$ ^= this.maxNumberOfAttributes;
        h$ *= 1000003;
        h$ ^= this.maxNumberOfEvents;
        h$ *= 1000003;
        h$ ^= this.maxNumberOfLinks;
        h$ *= 1000003;
        h$ ^= this.maxNumberOfAttributesPerEvent;
        h$ *= 1000003;
        return h$ ^= this.maxNumberOfAttributesPerLink;
    }

    @Override
    public TraceConfig.Builder toBuilder() {
        return new Builder(this);
    }

    static final class Builder
    extends TraceConfig.Builder {
        private Sampler sampler;
        private Integer maxNumberOfAttributes;
        private Integer maxNumberOfEvents;
        private Integer maxNumberOfLinks;
        private Integer maxNumberOfAttributesPerEvent;
        private Integer maxNumberOfAttributesPerLink;

        Builder() {
        }

        private Builder(TraceConfig source) {
            this.sampler = source.getSampler();
            this.maxNumberOfAttributes = source.getMaxNumberOfAttributes();
            this.maxNumberOfEvents = source.getMaxNumberOfEvents();
            this.maxNumberOfLinks = source.getMaxNumberOfLinks();
            this.maxNumberOfAttributesPerEvent = source.getMaxNumberOfAttributesPerEvent();
            this.maxNumberOfAttributesPerLink = source.getMaxNumberOfAttributesPerLink();
        }

        @Override
        public TraceConfig.Builder setSampler(Sampler sampler) {
            if (sampler == null) {
                throw new NullPointerException("Null sampler");
            }
            this.sampler = sampler;
            return this;
        }

        @Override
        public TraceConfig.Builder setMaxNumberOfAttributes(int maxNumberOfAttributes) {
            this.maxNumberOfAttributes = maxNumberOfAttributes;
            return this;
        }

        @Override
        public TraceConfig.Builder setMaxNumberOfEvents(int maxNumberOfEvents) {
            this.maxNumberOfEvents = maxNumberOfEvents;
            return this;
        }

        @Override
        public TraceConfig.Builder setMaxNumberOfLinks(int maxNumberOfLinks) {
            this.maxNumberOfLinks = maxNumberOfLinks;
            return this;
        }

        @Override
        public TraceConfig.Builder setMaxNumberOfAttributesPerEvent(int maxNumberOfAttributesPerEvent) {
            this.maxNumberOfAttributesPerEvent = maxNumberOfAttributesPerEvent;
            return this;
        }

        @Override
        public TraceConfig.Builder setMaxNumberOfAttributesPerLink(int maxNumberOfAttributesPerLink) {
            this.maxNumberOfAttributesPerLink = maxNumberOfAttributesPerLink;
            return this;
        }

        @Override
        TraceConfig autoBuild() {
            String missing = "";
            if (this.sampler == null) {
                missing = missing + " sampler";
            }
            if (this.maxNumberOfAttributes == null) {
                missing = missing + " maxNumberOfAttributes";
            }
            if (this.maxNumberOfEvents == null) {
                missing = missing + " maxNumberOfEvents";
            }
            if (this.maxNumberOfLinks == null) {
                missing = missing + " maxNumberOfLinks";
            }
            if (this.maxNumberOfAttributesPerEvent == null) {
                missing = missing + " maxNumberOfAttributesPerEvent";
            }
            if (this.maxNumberOfAttributesPerLink == null) {
                missing = missing + " maxNumberOfAttributesPerLink";
            }
            if (!missing.isEmpty()) {
                throw new IllegalStateException("Missing required properties:" + missing);
            }
            return new AutoValue_TraceConfig(this.sampler, this.maxNumberOfAttributes, this.maxNumberOfEvents, this.maxNumberOfLinks, this.maxNumberOfAttributesPerEvent, this.maxNumberOfAttributesPerLink);
        }
    }
}

