/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.metrics;

import io.opentelemetry.sdk.metrics.AbstractBoundInstrument;
import io.opentelemetry.sdk.metrics.AbstractInstrument;
import io.opentelemetry.sdk.metrics.ActiveBatcher;
import io.opentelemetry.sdk.metrics.Batcher;
import io.opentelemetry.sdk.metrics.InstrumentDescriptor;
import io.opentelemetry.sdk.metrics.LabelSetSdk;
import io.opentelemetry.sdk.metrics.MeterProviderSharedState;
import io.opentelemetry.sdk.metrics.MeterSharedState;
import io.opentelemetry.sdk.metrics.data.MetricData;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReentrantLock;

abstract class AbstractInstrumentWithBinding<B extends AbstractBoundInstrument>
extends AbstractInstrument {
    private final ConcurrentHashMap<LabelSetSdk, B> boundLabels = new ConcurrentHashMap();
    private final ReentrantLock collectLock = new ReentrantLock();

    AbstractInstrumentWithBinding(InstrumentDescriptor descriptor, MeterProviderSharedState meterProviderSharedState, MeterSharedState meterSharedState, ActiveBatcher activeBatcher) {
        super(descriptor, meterProviderSharedState, meterSharedState, activeBatcher);
    }

    final B bindInternal(LabelSetSdk labelSet) {
        AbstractBoundInstrument oldBound;
        AbstractBoundInstrument binding = (AbstractBoundInstrument)this.boundLabels.get(labelSet);
        if (binding != null && binding.bind()) {
            return (B)binding;
        }
        binding = this.newBinding(this.getActiveBatcher());
        while ((oldBound = this.boundLabels.putIfAbsent(labelSet, binding)) != null) {
            if (oldBound.bind()) {
                return (B)oldBound;
            }
            this.boundLabels.remove(labelSet, oldBound);
        }
        return (B)binding;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    final List<MetricData> collectAll() {
        this.collectLock.lock();
        try {
            ActiveBatcher batcher = this.getActiveBatcher();
            for (Map.Entry<LabelSetSdk, B> entry : this.boundLabels.entrySet()) {
                boolean unmappedEntry = ((AbstractBoundInstrument)entry.getValue()).tryUnmap();
                if (unmappedEntry) {
                    this.boundLabels.remove(entry.getKey(), entry.getValue());
                }
                batcher.batch(entry.getKey(), ((AbstractBoundInstrument)entry.getValue()).getAggregator(), unmappedEntry);
            }
            List<MetricData> list = batcher.completeCollectionCycle();
            return list;
        }
        finally {
            this.collectLock.unlock();
        }
    }

    abstract B newBinding(Batcher var1);
}

