/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.trace.data;

import com.google.auto.value.AutoValue;
import io.opentelemetry.common.AttributeValue;
import io.opentelemetry.sdk.common.InstrumentationLibraryInfo;
import io.opentelemetry.sdk.resources.Resource;
import io.opentelemetry.sdk.trace.data.AutoValue_SpanData;
import io.opentelemetry.sdk.trace.data.AutoValue_SpanData_Link;
import io.opentelemetry.sdk.trace.data.AutoValue_SpanData_TimedEvent;
import io.opentelemetry.trace.Event;
import io.opentelemetry.trace.Span;
import io.opentelemetry.trace.SpanContext;
import io.opentelemetry.trace.SpanId;
import io.opentelemetry.trace.Status;
import io.opentelemetry.trace.TraceFlags;
import io.opentelemetry.trace.TraceId;
import io.opentelemetry.trace.TraceState;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.concurrent.Immutable;

@Immutable
@AutoValue
public abstract class SpanData {
    public abstract TraceId getTraceId();

    public abstract SpanId getSpanId();

    public abstract TraceFlags getTraceFlags();

    public abstract TraceState getTraceState();

    public abstract SpanId getParentSpanId();

    public abstract Resource getResource();

    public abstract InstrumentationLibraryInfo getInstrumentationLibraryInfo();

    public abstract String getName();

    public abstract Span.Kind getKind();

    public abstract long getStartEpochNanos();

    public abstract Map<String, AttributeValue> getAttributes();

    public abstract List<TimedEvent> getTimedEvents();

    public abstract List<Link> getLinks();

    public abstract Status getStatus();

    public abstract long getEndEpochNanos();

    public abstract boolean getHasRemoteParent();

    public abstract boolean getHasEnded();

    public abstract int getTotalRecordedEvents();

    public abstract int getTotalRecordedLinks();

    public abstract int getDroppedAttributeCount();

    public static Builder newBuilder() {
        return new AutoValue_SpanData.Builder().setParentSpanId(SpanId.getInvalid()).setInstrumentationLibraryInfo(InstrumentationLibraryInfo.getEmpty()).setLinks(Collections.emptyList()).setTotalRecordedLinks(0).setAttributes(Collections.emptyMap()).setTimedEvents(Collections.emptyList()).setTotalRecordedEvents(0).setResource(Resource.getEmpty()).setTraceState(TraceState.getDefault()).setTraceFlags(TraceFlags.getDefault()).setHasRemoteParent(false).setDroppedAttributeCount(0);
    }

    @AutoValue.Builder
    public static abstract class Builder {
        abstract SpanData autoBuild();

        abstract Map<String, AttributeValue> getAttributes();

        abstract List<TimedEvent> getTimedEvents();

        abstract List<Link> getLinks();

        public SpanData build() {
            this.setAttributes(Collections.unmodifiableMap(new HashMap<String, AttributeValue>(this.getAttributes())));
            this.setTimedEvents(Collections.unmodifiableList(new ArrayList<TimedEvent>(this.getTimedEvents())));
            this.setLinks(Collections.unmodifiableList(new ArrayList<Link>(this.getLinks())));
            return this.autoBuild();
        }

        public abstract Builder setTraceId(TraceId var1);

        public abstract Builder setSpanId(SpanId var1);

        public abstract Builder setTraceFlags(TraceFlags var1);

        public abstract Builder setTraceState(TraceState var1);

        public abstract Builder setParentSpanId(SpanId var1);

        public abstract Builder setResource(Resource var1);

        public abstract Builder setInstrumentationLibraryInfo(InstrumentationLibraryInfo var1);

        public abstract Builder setName(String var1);

        public abstract Builder setStartEpochNanos(long var1);

        public abstract Builder setEndEpochNanos(long var1);

        public abstract Builder setAttributes(Map<String, AttributeValue> var1);

        public abstract Builder setTimedEvents(List<TimedEvent> var1);

        public abstract Builder setStatus(Status var1);

        public abstract Builder setKind(Span.Kind var1);

        public abstract Builder setLinks(List<Link> var1);

        public abstract Builder setHasRemoteParent(boolean var1);

        public abstract Builder setHasEnded(boolean var1);

        public abstract Builder setTotalRecordedEvents(int var1);

        public abstract Builder setTotalRecordedLinks(int var1);

        public abstract Builder setDroppedAttributeCount(int var1);
    }

    @Immutable
    @AutoValue
    public static abstract class TimedEvent
    implements Event {
        private static final int ZERO_DROPPED_ATTRIBUTE_COUNT = 0;

        public static TimedEvent create(long epochNanos, String name, Map<String, AttributeValue> attributes) {
            return new AutoValue_SpanData_TimedEvent(epochNanos, name, attributes, 0);
        }

        public static TimedEvent create(long epochNanos, String name, Map<String, AttributeValue> attributes, int droppedAttributeCount) {
            return new AutoValue_SpanData_TimedEvent(epochNanos, name, attributes, droppedAttributeCount);
        }

        public abstract long getEpochNanos();

        public abstract String getName();

        public abstract Map<String, AttributeValue> getAttributes();

        public abstract int getDroppedAttributeCount();

        TimedEvent() {
        }
    }

    @Immutable
    @AutoValue
    public static abstract class Link
    implements io.opentelemetry.trace.Link {
        private static final int ZERO_DROPPED_ATTRIBUTE_COUNT = 0;

        public static Link create(SpanContext spanContext) {
            return new AutoValue_SpanData_Link(spanContext, Collections.emptyMap(), 0);
        }

        public static Link create(SpanContext spanContext, Map<String, AttributeValue> attributes) {
            return new AutoValue_SpanData_Link(spanContext, Collections.unmodifiableMap(new LinkedHashMap<String, AttributeValue>(attributes)), 0);
        }

        public static Link create(SpanContext spanContext, Map<String, AttributeValue> attributes, int droppedAttributeCount) {
            return new AutoValue_SpanData_Link(spanContext, Collections.unmodifiableMap(new LinkedHashMap<String, AttributeValue>(attributes)), droppedAttributeCount);
        }

        public abstract int getDroppedAttributeCount();

        Link() {
        }
    }
}

