/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.metrics;

import io.opentelemetry.metrics.LongCounter;
import io.opentelemetry.sdk.metrics.AbstractBoundInstrument;
import io.opentelemetry.sdk.metrics.AbstractCounter;
import io.opentelemetry.sdk.metrics.Batcher;
import io.opentelemetry.sdk.metrics.InstrumentDescriptor;
import io.opentelemetry.sdk.metrics.LabelSetSdk;
import io.opentelemetry.sdk.metrics.MeterProviderSharedState;
import io.opentelemetry.sdk.metrics.MeterSharedState;
import io.opentelemetry.sdk.metrics.common.InstrumentValueType;

final class LongCounterSdk
extends AbstractCounter<BoundInstrument>
implements LongCounter {
    private LongCounterSdk(InstrumentDescriptor descriptor, MeterProviderSharedState meterProviderSharedState, MeterSharedState meterSharedState, boolean monotonic) {
        super(descriptor, InstrumentValueType.LONG, meterProviderSharedState, meterSharedState, monotonic);
    }

    public void add(long delta, String ... labelKeyValuePairs) {
        this.add(delta, LabelSetSdk.create(labelKeyValuePairs));
    }

    void add(long delta, LabelSetSdk labelSet) {
        BoundInstrument boundInstrument = (BoundInstrument)this.bindInternal(labelSet);
        boundInstrument.add(delta);
        boundInstrument.unbind();
    }

    public BoundInstrument bind(String ... labelKeyValuePairs) {
        return (BoundInstrument)this.bindInternal(LabelSetSdk.create(labelKeyValuePairs));
    }

    @Override
    BoundInstrument newBinding(Batcher batcher) {
        return new BoundInstrument(this.isMonotonic(), batcher);
    }

    static final class Builder
    extends AbstractCounter.Builder<Builder>
    implements LongCounter.Builder {
        Builder(String name, MeterProviderSharedState meterProviderSharedState, MeterSharedState meterSharedState) {
            super(name, meterProviderSharedState, meterSharedState);
        }

        @Override
        Builder getThis() {
            return this;
        }

        public LongCounterSdk build() {
            return this.register(new LongCounterSdk(this.getInstrumentDescriptor(), this.getMeterProviderSharedState(), this.getMeterSharedState(), this.isMonotonic()));
        }
    }

    static final class BoundInstrument
    extends AbstractBoundInstrument
    implements LongCounter.BoundLongCounter {
        private final boolean monotonic;

        BoundInstrument(boolean monotonic, Batcher batcher) {
            super(batcher.getAggregator());
            this.monotonic = monotonic;
        }

        public void add(long delta) {
            if (this.monotonic && delta < 0L) {
                throw new IllegalArgumentException("monotonic counters can only increase");
            }
            this.recordLong(delta);
        }
    }
}

