/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.metrics;

import io.opentelemetry.internal.Utils;
import io.opentelemetry.metrics.DoubleObserver;
import io.opentelemetry.metrics.Observer;
import io.opentelemetry.sdk.metrics.AbstractObserver;
import io.opentelemetry.sdk.metrics.ActiveBatcher;
import io.opentelemetry.sdk.metrics.InstrumentDescriptor;
import io.opentelemetry.sdk.metrics.LabelSetSdk;
import io.opentelemetry.sdk.metrics.MeterProviderSharedState;
import io.opentelemetry.sdk.metrics.MeterSharedState;
import io.opentelemetry.sdk.metrics.aggregator.Aggregator;
import io.opentelemetry.sdk.metrics.common.InstrumentValueType;
import io.opentelemetry.sdk.metrics.data.MetricData;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.locks.ReentrantLock;
import javax.annotation.Nullable;

final class DoubleObserverSdk
extends AbstractObserver
implements DoubleObserver {
    @Nullable
    private volatile Observer.Callback<DoubleObserver.ResultDoubleObserver> metricUpdater = null;
    private final ReentrantLock collectLock = new ReentrantLock();

    DoubleObserverSdk(InstrumentDescriptor descriptor, MeterProviderSharedState meterProviderSharedState, MeterSharedState meterSharedState, boolean monotonic) {
        super(descriptor, InstrumentValueType.DOUBLE, meterProviderSharedState, meterSharedState, monotonic);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    List<MetricData> collectAll() {
        Observer.Callback<DoubleObserver.ResultDoubleObserver> currentMetricUpdater = this.metricUpdater;
        if (currentMetricUpdater == null) {
            return Collections.emptyList();
        }
        this.collectLock.lock();
        try {
            ActiveBatcher activeBatcher = this.getActiveBatcher();
            currentMetricUpdater.update((Object)new ResultDoubleObserverSdk(activeBatcher, this.isMonotonic()));
            List<MetricData> list = activeBatcher.completeCollectionCycle();
            return list;
        }
        finally {
            this.collectLock.unlock();
        }
    }

    public void setCallback(Observer.Callback<DoubleObserver.ResultDoubleObserver> metricUpdater) {
        this.metricUpdater = (Observer.Callback)Utils.checkNotNull(metricUpdater, (Object)"metricUpdater");
    }

    private static final class ResultDoubleObserverSdk
    implements DoubleObserver.ResultDoubleObserver {
        private final ActiveBatcher activeBatcher;
        private final boolean monotonic;

        private ResultDoubleObserverSdk(ActiveBatcher activeBatcher, boolean monotonic) {
            this.activeBatcher = activeBatcher;
            this.monotonic = monotonic;
        }

        public void observe(double value, String ... keyValueLabelPairs) {
            if (this.monotonic && value < 0.0) {
                throw new IllegalArgumentException("monotonic observers can only record positive values");
            }
            Aggregator aggregator = this.activeBatcher.getAggregator();
            aggregator.recordDouble(value);
            this.activeBatcher.batch(LabelSetSdk.create(keyValueLabelPairs), aggregator, false);
        }
    }

    static final class Builder
    extends AbstractObserver.Builder<Builder>
    implements DoubleObserver.Builder {
        Builder(String name, MeterProviderSharedState meterProviderSharedState, MeterSharedState meterSharedState) {
            super(name, meterProviderSharedState, meterSharedState);
        }

        @Override
        Builder getThis() {
            return this;
        }

        public DoubleObserverSdk build() {
            return this.register(new DoubleObserverSdk(this.getInstrumentDescriptor(), this.getMeterProviderSharedState(), this.getMeterSharedState(), this.isMonotonic()));
        }
    }
}

