/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.trace;

import io.opentelemetry.sdk.common.Clock;
import io.opentelemetry.sdk.internal.MillisClock;
import io.opentelemetry.sdk.resources.EnvVarResource;
import io.opentelemetry.sdk.resources.Resource;
import io.opentelemetry.sdk.trace.IdsGenerator;
import io.opentelemetry.sdk.trace.InstrumentationLibraryInfo;
import io.opentelemetry.sdk.trace.RandomIdsGenerator;
import io.opentelemetry.sdk.trace.SpanProcessor;
import io.opentelemetry.sdk.trace.TracerSdk;
import io.opentelemetry.sdk.trace.TracerSharedState;
import io.opentelemetry.sdk.trace.config.TraceConfig;
import io.opentelemetry.trace.TracerFactory;
import java.security.SecureRandom;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;

public class TracerSdkFactory
implements TracerFactory {
    private final Object lock = new Object();
    private static final Logger logger = Logger.getLogger(TracerFactory.class.getName());
    private final Map<InstrumentationLibraryInfo, TracerSdk> tracerRegistry = new ConcurrentHashMap<InstrumentationLibraryInfo, TracerSdk>();
    private final TracerSharedState sharedState;

    public static TracerSdkFactory create() {
        return new TracerSdkFactory(MillisClock.getInstance(), new RandomIdsGenerator(new SecureRandom()), EnvVarResource.getResource());
    }

    private TracerSdkFactory(Clock clock, IdsGenerator idsGenerator, Resource resource) {
        this.sharedState = new TracerSharedState(clock, idsGenerator, resource);
    }

    public TracerSdk get(String instrumentationName) {
        return this.get(instrumentationName, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TracerSdk get(String instrumentationName, String instrumentationVersion) {
        InstrumentationLibraryInfo instrumentationLibraryInfo = InstrumentationLibraryInfo.create(instrumentationName, instrumentationVersion);
        TracerSdk tracer = this.tracerRegistry.get(instrumentationLibraryInfo);
        if (tracer == null) {
            Object object = this.lock;
            synchronized (object) {
                tracer = this.tracerRegistry.get(instrumentationLibraryInfo);
                if (tracer != null) {
                    return tracer;
                }
                tracer = new TracerSdk(this.sharedState, instrumentationLibraryInfo);
                this.tracerRegistry.put(instrumentationLibraryInfo, tracer);
            }
        }
        return tracer;
    }

    public TraceConfig getActiveTraceConfig() {
        return this.sharedState.getActiveTraceConfig();
    }

    public void updateActiveTraceConfig(TraceConfig traceConfig) {
        this.sharedState.updateActiveTraceConfig(traceConfig);
    }

    public void addSpanProcessor(SpanProcessor spanProcessor) {
        this.sharedState.addSpanProcessor(spanProcessor);
    }

    public void shutdown() {
        if (this.sharedState.isStopped()) {
            logger.log(Level.WARNING, "Calling shutdown() multiple times.");
            return;
        }
        this.sharedState.stop();
    }
}

