/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.trace;

import io.opentelemetry.sdk.trace.IdsGenerator;
import io.opentelemetry.trace.SpanId;
import io.opentelemetry.trace.TraceId;
import java.util.Random;

final class RandomIdsGenerator
implements IdsGenerator {
    private static final long INVALID_ID = 0L;
    private final Random random;

    RandomIdsGenerator(Random random) {
        this.random = random;
    }

    @Override
    public SpanId generateSpanId() {
        long id;
        while ((id = this.random.nextLong()) == 0L) {
        }
        return new SpanId(id);
    }

    @Override
    public TraceId generateTraceId() {
        long idLo;
        long idHi;
        do {
            idHi = this.random.nextLong();
            idLo = this.random.nextLong();
        } while (idHi == 0L && idLo == 0L);
        return new TraceId(idHi, idLo);
    }
}

