/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.resources;

import io.opentelemetry.sdk.resources.Resource;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public final class EnvVarResource {
    private static final String OC_RESOURCE_LABELS_ENV = "OC_RESOURCE_LABELS";
    private static final String LABEL_LIST_SPLITTER = ",";
    private static final String LABEL_KEY_VALUE_SPLITTER = "=";
    private static final Resource ENV_VAR_RESOURCE = Resource.create(EnvVarResource.parseResourceLabels(System.getenv("OC_RESOURCE_LABELS")));

    private EnvVarResource() {
    }

    public static Resource getResource() {
        return ENV_VAR_RESOURCE;
    }

    private static Map<String, String> parseResourceLabels(@Nullable String rawEnvLabels) {
        String[] rawLabels;
        if (rawEnvLabels == null) {
            return Collections.emptyMap();
        }
        HashMap<String, String> labels = new HashMap<String, String>();
        for (String rawLabel : rawLabels = rawEnvLabels.split(LABEL_LIST_SPLITTER, -1)) {
            String[] keyValuePair = rawLabel.split(LABEL_KEY_VALUE_SPLITTER, -1);
            if (keyValuePair.length != 2) continue;
            String key = keyValuePair[0].trim();
            String value = keyValuePair[1].trim().replaceAll("^\"|\"$", "");
            labels.put(key, value);
        }
        return Collections.unmodifiableMap(labels);
    }
}

