/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.metrics;

import io.opentelemetry.internal.StringUtils;
import io.opentelemetry.internal.Utils;
import io.opentelemetry.metrics.Metric;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

abstract class AbstractMetricBuilder<B extends Metric.Builder<B, V>, V>
implements Metric.Builder<B, V> {
    static final int NAME_MAX_LENGTH = 255;
    static final String ERROR_MESSAGE_INVALID_NAME = "Name should be a ASCII string with a length no greater than 255 characters.";
    private final String name;
    private String description = "";
    private String unit = "1";
    private List<String> labelKeys = Collections.emptyList();
    private Map<String, String> constantLabels = Collections.emptyMap();

    AbstractMetricBuilder(String name) {
        Utils.checkNotNull((Object)name, (Object)"name");
        Utils.checkArgument((StringUtils.isPrintableString((String)name) && name.length() <= 255 ? 1 : 0) != 0, (Object)ERROR_MESSAGE_INVALID_NAME);
        this.name = name;
    }

    public final B setDescription(String description) {
        this.description = (String)Utils.checkNotNull((Object)description, (Object)"description");
        return this.getThis();
    }

    public final B setUnit(String unit) {
        this.unit = (String)Utils.checkNotNull((Object)unit, (Object)"unit");
        return this.getThis();
    }

    public final B setLabelKeys(List<String> labelKeys) {
        Utils.checkListElementNotNull((List)((List)Utils.checkNotNull(labelKeys, (Object)"labelKeys")), (Object)"labelKey");
        this.labelKeys = Collections.unmodifiableList(new ArrayList<String>(labelKeys));
        return this.getThis();
    }

    public final B setConstantLabels(Map<String, String> constantLabels) {
        Utils.checkMapKeysNotNull((Map)((Map)Utils.checkNotNull(constantLabels, (Object)"constantLabels")), (Object)"constantLabel");
        this.constantLabels = Collections.unmodifiableMap(new HashMap<String, String>(constantLabels));
        return this.getThis();
    }

    final String getName() {
        return this.name;
    }

    final String getDescription() {
        return this.description;
    }

    final String getUnit() {
        return this.unit;
    }

    final List<String> getLabelKeys() {
        return this.labelKeys;
    }

    final Map<String, String> getConstantLabels() {
        return this.constantLabels;
    }

    abstract B getThis();
}

