/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk;

import io.opentelemetry.api.DefaultOpenTelemetryBuilder;
import io.opentelemetry.api.GlobalOpenTelemetry;
import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.api.metrics.MeterProvider;
import io.opentelemetry.api.trace.TracerProvider;
import io.opentelemetry.context.propagation.ContextPropagators;
import io.opentelemetry.sdk.OpenTelemetrySdk;
import io.opentelemetry.sdk.metrics.SdkMeterProvider;
import io.opentelemetry.sdk.trace.SdkTracerProvider;

public final class OpenTelemetrySdkBuilder
extends DefaultOpenTelemetryBuilder {
    public OpenTelemetrySdkBuilder setTracerProvider(TracerProvider tracerProvider) {
        if (!(tracerProvider instanceof SdkTracerProvider)) {
            throw new IllegalArgumentException("The OpenTelemetrySdk can only be configured with a TracerSdkProvider");
        }
        super.setTracerProvider(tracerProvider);
        return this;
    }

    @Deprecated
    public OpenTelemetrySdkBuilder setMeterProvider(MeterProvider meterProvider) {
        if (!(meterProvider instanceof SdkMeterProvider)) {
            throw new IllegalArgumentException("The OpenTelemetrySdk can only be configured with a MeterSdkProvider");
        }
        super.setMeterProvider(meterProvider);
        return this;
    }

    public OpenTelemetrySdkBuilder setPropagators(ContextPropagators propagators) {
        super.setPropagators(propagators);
        return this;
    }

    public OpenTelemetrySdk build() {
        if (this.meterProvider == null) {
            this.meterProvider = SdkMeterProvider.builder().build();
        }
        if (this.tracerProvider == null) {
            this.tracerProvider = SdkTracerProvider.builder().build();
        }
        OpenTelemetrySdk sdk = new OpenTelemetrySdk(new OpenTelemetrySdk.ObfuscatedTracerProvider(this.tracerProvider), this.meterProvider, this.propagators);
        if (OpenTelemetrySdk.INITIALIZED_GLOBAL.compareAndSet(false, true)) {
            GlobalOpenTelemetry.set((OpenTelemetry)sdk);
        }
        return sdk;
    }
}

