/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk;

import io.opentelemetry.api.DefaultOpenTelemetry;
import io.opentelemetry.api.GlobalOpenTelemetry;
import io.opentelemetry.api.metrics.MeterProvider;
import io.opentelemetry.api.trace.Tracer;
import io.opentelemetry.api.trace.TracerProvider;
import io.opentelemetry.context.propagation.ContextPropagators;
import io.opentelemetry.sdk.OpenTelemetrySdkBuilder;
import io.opentelemetry.sdk.metrics.SdkMeterProvider;
import io.opentelemetry.sdk.trace.SdkTracerManagement;
import io.opentelemetry.sdk.trace.SdkTracerProvider;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public final class OpenTelemetrySdk
extends DefaultOpenTelemetry {
    static final AtomicBoolean INITIALIZED_GLOBAL = new AtomicBoolean();

    public static OpenTelemetrySdkBuilder builder() {
        return new OpenTelemetrySdkBuilder();
    }

    public static OpenTelemetrySdk get() {
        return (OpenTelemetrySdk)GlobalOpenTelemetry.get();
    }

    public static SdkTracerManagement getGlobalTracerManagement() {
        TracerProvider tracerProvider = GlobalOpenTelemetry.get().getTracerProvider();
        if (!(tracerProvider instanceof ObfuscatedTracerProvider)) {
            throw new IllegalStateException("Trying to access global TracerSdkManagement but global TracerProvider is not an instance created by this SDK.");
        }
        return (SdkTracerProvider)((ObfuscatedTracerProvider)tracerProvider).unobfuscate();
    }

    @Deprecated
    public static SdkMeterProvider getGlobalMeterProvider() {
        return (SdkMeterProvider)GlobalOpenTelemetry.get().getMeterProvider();
    }

    OpenTelemetrySdk(TracerProvider tracerProvider, MeterProvider meterProvider, ContextPropagators contextPropagators) {
        super(tracerProvider, meterProvider, contextPropagators);
    }

    public SdkTracerManagement getTracerManagement() {
        return (SdkTracerProvider)((ObfuscatedTracerProvider)this.getTracerProvider()).unobfuscate();
    }

    @ThreadSafe
    static class ObfuscatedTracerProvider
    implements TracerProvider {
        private final TracerProvider delegate;

        ObfuscatedTracerProvider(TracerProvider delegate) {
            this.delegate = delegate;
        }

        public Tracer get(String instrumentationName) {
            return this.delegate.get(instrumentationName);
        }

        public Tracer get(String instrumentationName, String instrumentationVersion) {
            return this.delegate.get(instrumentationName, instrumentationVersion);
        }

        public TracerProvider unobfuscate() {
            return this.delegate;
        }
    }
}

