/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk;

import com.google.common.annotations.VisibleForTesting;
import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.api.internal.Obfuscated;
import io.opentelemetry.api.metrics.MeterProvider;
import io.opentelemetry.api.metrics.spi.MeterProviderFactory;
import io.opentelemetry.api.trace.Tracer;
import io.opentelemetry.api.trace.TracerProvider;
import io.opentelemetry.api.trace.spi.TracerProviderFactory;
import io.opentelemetry.context.propagation.ContextPropagators;
import io.opentelemetry.context.propagation.DefaultContextPropagators;
import io.opentelemetry.sdk.common.Clock;
import io.opentelemetry.sdk.internal.MillisClock;
import io.opentelemetry.sdk.metrics.MeterSdkProvider;
import io.opentelemetry.sdk.resources.Resource;
import io.opentelemetry.sdk.trace.TracerSdkManagement;
import io.opentelemetry.sdk.trace.TracerSdkProvider;
import java.util.Objects;
import java.util.ServiceLoader;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public final class OpenTelemetrySdk
implements OpenTelemetry {
    private static final boolean HAS_METRICS_SDK = OpenTelemetrySdk.hasClass("io.opentelemetry.sdk.metrics.MeterSdk");
    private static final boolean HAS_TRACING_SDK = OpenTelemetrySdk.hasClass("io.opentelemetry.sdk.trace.TracerSdk");
    private static final AtomicBoolean INITIALIZED_GLOBAL = new AtomicBoolean();
    private final TracerProvider tracerProvider;
    private final MeterProvider meterProvider;
    private final ContextPropagators contextPropagators;
    private final Clock clock;
    private final Resource resource;

    public static Builder builder() {
        return new Builder();
    }

    public static OpenTelemetrySdk get() {
        return (OpenTelemetrySdk)OpenTelemetry.get();
    }

    public static TracerSdkManagement getGlobalTracerManagement() {
        TracerProvider tracerProvider = OpenTelemetry.get().getTracerProvider();
        if (!(tracerProvider instanceof ObfuscatedTracerProvider)) {
            throw new IllegalStateException("Trying to access global TracerSdkManagement but global TracerProvider is not an instance created by this SDK.");
        }
        return (TracerSdkProvider)((ObfuscatedTracerProvider)tracerProvider).unobfuscate();
    }

    public static MeterSdkProvider getGlobalMeterProvider() {
        return (MeterSdkProvider)OpenTelemetry.get().getMeterProvider();
    }

    private OpenTelemetrySdk(TracerProvider tracerProvider, MeterProvider meterProvider, ContextPropagators contextPropagators, Clock clock, Resource resource) {
        this.tracerProvider = tracerProvider;
        this.meterProvider = meterProvider;
        this.contextPropagators = contextPropagators;
        this.clock = clock;
        this.resource = resource;
    }

    public TracerProvider getTracerProvider() {
        return this.tracerProvider;
    }

    public MeterProvider getMeterProvider() {
        return this.meterProvider;
    }

    public ContextPropagators getPropagators() {
        return this.contextPropagators;
    }

    public Resource getResource() {
        return this.resource;
    }

    public Clock getClock() {
        return this.clock;
    }

    public TracerSdkManagement getTracerManagement() {
        return (TracerSdkProvider)((ObfuscatedTracerProvider)this.tracerProvider).unobfuscate();
    }

    public Builder toBuilder() {
        return OpenTelemetrySdk.builder().setTracerProvider(this.tracerProvider).setMeterProvider(this.meterProvider).setPropagators(this.getPropagators()).setClock(this.clock).setResource(this.resource);
    }

    @Nullable
    private static <T> T loadSpi(Class<T> providerClass) {
        String specifiedProvider = System.getProperty(providerClass.getName());
        ServiceLoader<T> providers = ServiceLoader.load(providerClass);
        for (T provider : providers) {
            if (specifiedProvider != null && !specifiedProvider.equals(provider.getClass().getName())) continue;
            return provider;
        }
        if (specifiedProvider != null) {
            throw new IllegalStateException(String.format("Service provider %s not found", specifiedProvider));
        }
        return null;
    }

    private static boolean hasClass(String className) {
        try {
            Class.forName(className);
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    @ThreadSafe
    @VisibleForTesting
    static class ObfuscatedTracerProvider
    implements TracerProvider,
    Obfuscated<TracerProvider> {
        private final TracerProvider delegate;

        private ObfuscatedTracerProvider(TracerProvider delegate) {
            this.delegate = delegate;
        }

        public Tracer get(String instrumentationName) {
            return this.delegate.get(instrumentationName);
        }

        public Tracer get(String instrumentationName, String instrumentationVersion) {
            return this.delegate.get(instrumentationName, instrumentationVersion);
        }

        public TracerProvider unobfuscate() {
            return this.delegate;
        }
    }

    public static class Builder
    implements OpenTelemetry.Builder<Builder> {
        private Clock clock = MillisClock.getInstance();
        private Resource resource = Resource.getDefault();
        private ContextPropagators propagators = DefaultContextPropagators.builder().build();
        private TracerProvider tracerProvider;
        private MeterProvider meterProvider;

        public Builder setTracerProvider(TracerProvider tracerProvider) {
            Objects.requireNonNull(tracerProvider, "tracerProvider");
            this.tracerProvider = tracerProvider;
            return this;
        }

        public Builder setMeterProvider(MeterProvider meterProvider) {
            Objects.requireNonNull(meterProvider, "meterProvider");
            this.meterProvider = meterProvider;
            return this;
        }

        public Builder setPropagators(ContextPropagators propagators) {
            Objects.requireNonNull(propagators, "propagators");
            this.propagators = propagators;
            return this;
        }

        public Builder setClock(Clock clock) {
            Objects.requireNonNull(clock, "clock");
            this.clock = clock;
            return this;
        }

        public Builder setResource(Resource resource) {
            Objects.requireNonNull(resource, "resource");
            this.resource = resource;
            return this;
        }

        public OpenTelemetrySdk build() {
            TracerProvider tracerProvider;
            Object meterProvider = this.meterProvider;
            if (meterProvider == null) {
                MeterProviderFactory meterProviderFactory = (MeterProviderFactory)OpenTelemetrySdk.loadSpi(MeterProviderFactory.class);
                meterProvider = meterProviderFactory != null ? meterProviderFactory.create() : (HAS_METRICS_SDK ? MeterSdkProvider.builder().setClock(this.clock).setResource(this.resource).build() : MeterProvider.getDefault());
            }
            if ((tracerProvider = this.tracerProvider) == null) {
                TracerProviderFactory tracerProviderFactory = (TracerProviderFactory)OpenTelemetrySdk.loadSpi(TracerProviderFactory.class);
                tracerProvider = tracerProviderFactory != null ? new ObfuscatedTracerProvider(tracerProviderFactory.create()) : (HAS_TRACING_SDK ? new ObfuscatedTracerProvider((TracerProvider)TracerSdkProvider.builder().setClock(this.clock).setResource(this.resource).build()) : TracerProvider.getDefault());
            }
            OpenTelemetrySdk sdk = new OpenTelemetrySdk(tracerProvider, (MeterProvider)meterProvider, this.propagators, this.clock, this.resource);
            if (INITIALIZED_GLOBAL.compareAndSet(false, true)) {
                OpenTelemetry.set((OpenTelemetry)sdk);
            }
            return sdk;
        }
    }
}

