/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.trace.data;

import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.trace.SpanContext;
import io.opentelemetry.api.trace.SpanKind;
import io.opentelemetry.sdk.common.InstrumentationLibraryInfo;
import io.opentelemetry.sdk.resources.Resource;
import io.opentelemetry.sdk.trace.data.EventData;
import io.opentelemetry.sdk.trace.data.LinkData;
import io.opentelemetry.sdk.trace.data.StatusData;
import java.util.List;
import javax.annotation.concurrent.Immutable;

@Immutable
public interface SpanData {
    public SpanContext getSpanContext();

    default public String getTraceId() {
        return this.getSpanContext().getTraceId();
    }

    default public String getSpanId() {
        return this.getSpanContext().getSpanId();
    }

    public SpanContext getParentSpanContext();

    default public String getParentSpanId() {
        return this.getParentSpanContext().getSpanId();
    }

    public Resource getResource();

    public InstrumentationLibraryInfo getInstrumentationLibraryInfo();

    public String getName();

    public SpanKind getKind();

    public long getStartEpochNanos();

    public Attributes getAttributes();

    public List<EventData> getEvents();

    public List<LinkData> getLinks();

    public StatusData getStatus();

    public long getEndEpochNanos();

    public boolean hasEnded();

    public int getTotalRecordedEvents();

    public int getTotalRecordedLinks();

    public int getTotalAttributeCount();
}

