/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.trace;

import io.opentelemetry.api.internal.Utils;
import io.opentelemetry.sdk.trace.SpanLimits;

public final class SpanLimitsBuilder {
    private static final int DEFAULT_SPAN_MAX_NUM_ATTRIBUTES = 1000;
    private static final int DEFAULT_SPAN_MAX_NUM_EVENTS = 1000;
    private static final int DEFAULT_SPAN_MAX_NUM_LINKS = 1000;
    private static final int DEFAULT_SPAN_MAX_NUM_ATTRIBUTES_PER_EVENT = 32;
    private static final int DEFAULT_SPAN_MAX_NUM_ATTRIBUTES_PER_LINK = 32;
    private static final int DEFAULT_MAX_ATTRIBUTE_LENGTH = -1;
    private int maxNumAttributes = 1000;
    private int maxNumEvents = 1000;
    private int maxNumLinks = 1000;
    private int maxNumAttributesPerEvent = 32;
    private int maxNumAttributesPerLink = 32;
    private int maxAttributeLength = -1;

    SpanLimitsBuilder() {
    }

    public SpanLimitsBuilder setMaxNumberOfAttributes(int maxNumberOfAttributes) {
        Utils.checkArgument((maxNumberOfAttributes > 0 ? 1 : 0) != 0, (String)"maxNumberOfAttributes must be greater than 0");
        this.maxNumAttributes = maxNumberOfAttributes;
        return this;
    }

    public SpanLimitsBuilder setMaxNumberOfEvents(int maxNumberOfEvents) {
        Utils.checkArgument((maxNumberOfEvents > 0 ? 1 : 0) != 0, (String)"maxNumberOfEvents must be greater than 0");
        this.maxNumEvents = maxNumberOfEvents;
        return this;
    }

    public SpanLimitsBuilder setMaxNumberOfLinks(int maxNumberOfLinks) {
        Utils.checkArgument((maxNumberOfLinks > 0 ? 1 : 0) != 0, (String)"maxNumberOfLinks must be greater than 0");
        this.maxNumLinks = maxNumberOfLinks;
        return this;
    }

    public SpanLimitsBuilder setMaxNumberOfAttributesPerEvent(int maxNumberOfAttributesPerEvent) {
        Utils.checkArgument((maxNumberOfAttributesPerEvent > 0 ? 1 : 0) != 0, (String)"maxNumberOfAttributesPerEvent must be greater than 0");
        this.maxNumAttributesPerEvent = maxNumberOfAttributesPerEvent;
        return this;
    }

    public SpanLimitsBuilder setMaxNumberOfAttributesPerLink(int maxNumberOfAttributesPerLink) {
        Utils.checkArgument((maxNumberOfAttributesPerLink > 0 ? 1 : 0) != 0, (String)"maxNumberOfAttributesPerLink must be greater than 0");
        this.maxNumAttributesPerLink = maxNumberOfAttributesPerLink;
        return this;
    }

    public SpanLimitsBuilder setMaxLengthOfAttributeValues(int maxLengthOfAttributeValues) {
        Utils.checkArgument((maxLengthOfAttributeValues == -1 || maxLengthOfAttributeValues > 0 ? 1 : 0) != 0, (String)"maxLengthOfAttributeValues must be -1 to disable length restriction, or positive to enable length restriction");
        this.maxAttributeLength = maxLengthOfAttributeValues;
        return this;
    }

    public SpanLimits build() {
        return SpanLimits.create(this.maxNumAttributes, this.maxNumEvents, this.maxNumLinks, this.maxNumAttributesPerEvent, this.maxNumAttributesPerLink, this.maxAttributeLength);
    }
}

