/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.trace;

import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.common.AttributesBuilder;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.BiConsumer;

final class AttributesMap
implements Attributes {
    private final Map<AttributeKey<?>, Object> data;
    private final long capacity;
    private int totalAddedValues = 0;

    private AttributesMap(long capacity, Map<AttributeKey<?>, Object> data) {
        this.capacity = capacity;
        this.data = data;
    }

    AttributesMap(long capacity) {
        this(capacity, new LinkedHashMap());
    }

    public <T> void put(AttributeKey<T> key, T value) {
        if (key == null || key.getKey() == null || value == null) {
            return;
        }
        ++this.totalAddedValues;
        if ((long)this.data.size() >= this.capacity && !this.data.containsKey(key)) {
            return;
        }
        this.data.put(key, value);
    }

    int getTotalAddedValues() {
        return this.totalAddedValues;
    }

    public <T> T get(AttributeKey<T> key) {
        return (T)this.data.get(key);
    }

    public int size() {
        return this.data.size();
    }

    public boolean isEmpty() {
        return this.data.isEmpty();
    }

    public void forEach(BiConsumer<AttributeKey<?>, Object> consumer) {
        for (Map.Entry<AttributeKey<?>, Object> entry : this.data.entrySet()) {
            AttributeKey<?> key = entry.getKey();
            Object value = entry.getValue();
            consumer.accept(key, value);
        }
    }

    public Map<AttributeKey<?>, Object> asMap() {
        return Collections.unmodifiableMap(this.data);
    }

    public AttributesBuilder toBuilder() {
        return Attributes.builder().putAll((Attributes)this);
    }

    public String toString() {
        return "AttributesMap{data=" + this.data + ", capacity=" + this.capacity + ", totalAddedValues=" + this.totalAddedValues + '}';
    }

    Attributes immutableCopy() {
        LinkedHashMap dataCopy = new LinkedHashMap(this.data);
        return new AttributesMap(this.capacity, Collections.unmodifiableMap(dataCopy));
    }
}

