/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.trace.samplers;

import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.context.Context;
import io.opentelemetry.sdk.trace.data.SpanData;
import io.opentelemetry.sdk.trace.samplers.AlwaysOffSampler;
import io.opentelemetry.sdk.trace.samplers.AlwaysOnSampler;
import io.opentelemetry.sdk.trace.samplers.ParentBasedSamplerBuilder;
import io.opentelemetry.sdk.trace.samplers.SamplingResult;
import io.opentelemetry.sdk.trace.samplers.TraceIdRatioBasedSampler;
import java.util.List;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public interface Sampler {
    public static Sampler alwaysOn() {
        return AlwaysOnSampler.INSTANCE;
    }

    public static Sampler alwaysOff() {
        return AlwaysOffSampler.INSTANCE;
    }

    public static Sampler parentBased(Sampler root) {
        return Sampler.parentBasedBuilder(root).build();
    }

    public static ParentBasedSamplerBuilder parentBasedBuilder(Sampler root) {
        return new ParentBasedSamplerBuilder(root);
    }

    public static Sampler traceIdRatioBased(double ratio) {
        return TraceIdRatioBasedSampler.create(ratio);
    }

    public SamplingResult shouldSample(Context var1, String var2, String var3, Span.Kind var4, Attributes var5, List<SpanData.Link> var6);

    public String getDescription();
}

