/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.trace.samplers;

import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.SpanContext;
import io.opentelemetry.context.Context;
import io.opentelemetry.sdk.trace.data.SpanData;
import io.opentelemetry.sdk.trace.samplers.Sampler;
import io.opentelemetry.sdk.trace.samplers.SamplingResult;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
final class ParentBasedSampler
implements Sampler {
    private final Sampler root;
    private final Sampler remoteParentSampled;
    private final Sampler remoteParentNotSampled;
    private final Sampler localParentSampled;
    private final Sampler localParentNotSampled;

    ParentBasedSampler(Sampler root, @Nullable Sampler remoteParentSampled, @Nullable Sampler remoteParentNotSampled, @Nullable Sampler localParentSampled, @Nullable Sampler localParentNotSampled) {
        this.root = root;
        this.remoteParentSampled = remoteParentSampled == null ? Sampler.alwaysOn() : remoteParentSampled;
        this.remoteParentNotSampled = remoteParentNotSampled == null ? Sampler.alwaysOff() : remoteParentNotSampled;
        this.localParentSampled = localParentSampled == null ? Sampler.alwaysOn() : localParentSampled;
        this.localParentNotSampled = localParentNotSampled == null ? Sampler.alwaysOff() : localParentNotSampled;
    }

    @Override
    public SamplingResult shouldSample(Context parentContext, String traceId, String name, Span.Kind spanKind, Attributes attributes, List<SpanData.Link> parentLinks) {
        SpanContext parentSpanContext = Span.fromContext((Context)parentContext).getSpanContext();
        if (!parentSpanContext.isValid()) {
            return this.root.shouldSample(parentContext, traceId, name, spanKind, attributes, parentLinks);
        }
        if (parentSpanContext.isRemote()) {
            return parentSpanContext.isSampled() ? this.remoteParentSampled.shouldSample(parentContext, traceId, name, spanKind, attributes, parentLinks) : this.remoteParentNotSampled.shouldSample(parentContext, traceId, name, spanKind, attributes, parentLinks);
        }
        return parentSpanContext.isSampled() ? this.localParentSampled.shouldSample(parentContext, traceId, name, spanKind, attributes, parentLinks) : this.localParentNotSampled.shouldSample(parentContext, traceId, name, spanKind, attributes, parentLinks);
    }

    @Override
    public String getDescription() {
        return String.format("ParentBased{root:%s,remoteParentSampled:%s,remoteParentNotSampled:%s,localParentSampled:%s,localParentNotSampled:%s}", this.root.getDescription(), this.remoteParentSampled.getDescription(), this.remoteParentNotSampled.getDescription(), this.localParentSampled.getDescription(), this.localParentNotSampled.getDescription());
    }

    public String toString() {
        return this.getDescription();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ParentBasedSampler)) {
            return false;
        }
        ParentBasedSampler that = (ParentBasedSampler)o;
        if (!Objects.equals(this.root, that.root)) {
            return false;
        }
        if (!Objects.equals(this.remoteParentSampled, that.remoteParentSampled)) {
            return false;
        }
        if (!Objects.equals(this.remoteParentNotSampled, that.remoteParentNotSampled)) {
            return false;
        }
        if (!Objects.equals(this.localParentSampled, that.localParentSampled)) {
            return false;
        }
        return Objects.equals(this.localParentNotSampled, that.localParentNotSampled);
    }

    public int hashCode() {
        int result = this.root != null ? this.root.hashCode() : 0;
        result = 31 * result + (this.remoteParentSampled != null ? this.remoteParentSampled.hashCode() : 0);
        result = 31 * result + (this.remoteParentNotSampled != null ? this.remoteParentNotSampled.hashCode() : 0);
        result = 31 * result + (this.localParentSampled != null ? this.localParentSampled.hashCode() : 0);
        result = 31 * result + (this.localParentNotSampled != null ? this.localParentNotSampled.hashCode() : 0);
        return result;
    }
}

