/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.trace.export;

import io.opentelemetry.api.internal.Utils;
import io.opentelemetry.sdk.common.export.ConfigBuilder;
import io.opentelemetry.sdk.trace.export.BatchSpanProcessor;
import io.opentelemetry.sdk.trace.export.SpanExporter;
import java.util.Map;
import java.util.Objects;

public final class BatchSpanProcessorBuilder
extends ConfigBuilder<BatchSpanProcessorBuilder> {
    private static final String KEY_SCHEDULE_DELAY_MILLIS = "otel.bsp.schedule.delay.millis";
    private static final String KEY_MAX_QUEUE_SIZE = "otel.bsp.max.queue.size";
    private static final String KEY_MAX_EXPORT_BATCH_SIZE = "otel.bsp.max.export.batch.size";
    private static final String KEY_EXPORT_TIMEOUT_MILLIS = "otel.bsp.export.timeout.millis";
    private static final String KEY_SAMPLED = "otel.bsp.export.sampled";
    static final long DEFAULT_SCHEDULE_DELAY_MILLIS = 5000L;
    static final int DEFAULT_MAX_QUEUE_SIZE = 2048;
    static final int DEFAULT_MAX_EXPORT_BATCH_SIZE = 512;
    static final int DEFAULT_EXPORT_TIMEOUT_MILLIS = 30000;
    static final boolean DEFAULT_EXPORT_ONLY_SAMPLED = true;
    private final SpanExporter spanExporter;
    private long scheduleDelayMillis = 5000L;
    private int maxQueueSize = 2048;
    private int maxExportBatchSize = 512;
    private int exporterTimeoutMillis = 30000;
    private boolean exportOnlySampled = true;

    BatchSpanProcessorBuilder(SpanExporter spanExporter) {
        this.spanExporter = Objects.requireNonNull(spanExporter, "spanExporter");
    }

    protected BatchSpanProcessorBuilder fromConfigMap(Map<String, String> configMap, ConfigBuilder.NamingConvention namingConvention) {
        Boolean boolValue;
        Integer intValue;
        Long longValue = BatchSpanProcessorBuilder.getLongProperty((String)KEY_SCHEDULE_DELAY_MILLIS, (Map)(configMap = namingConvention.normalize(configMap)));
        if (longValue != null) {
            this.setScheduleDelayMillis(longValue);
        }
        if ((intValue = BatchSpanProcessorBuilder.getIntProperty((String)KEY_MAX_QUEUE_SIZE, (Map)configMap)) != null) {
            this.setMaxQueueSize(intValue);
        }
        if ((intValue = BatchSpanProcessorBuilder.getIntProperty((String)KEY_MAX_EXPORT_BATCH_SIZE, (Map)configMap)) != null) {
            this.setMaxExportBatchSize(intValue);
        }
        if ((intValue = BatchSpanProcessorBuilder.getIntProperty((String)KEY_EXPORT_TIMEOUT_MILLIS, (Map)configMap)) != null) {
            this.setExporterTimeoutMillis(intValue);
        }
        if ((boolValue = BatchSpanProcessorBuilder.getBooleanProperty((String)KEY_SAMPLED, (Map)configMap)) != null) {
            this.setExportOnlySampled(boolValue);
        }
        return this;
    }

    public BatchSpanProcessorBuilder setExportOnlySampled(boolean exportOnlySampled) {
        this.exportOnlySampled = exportOnlySampled;
        return this;
    }

    boolean getExportOnlySampled() {
        return this.exportOnlySampled;
    }

    public BatchSpanProcessorBuilder setScheduleDelayMillis(long scheduleDelayMillis) {
        this.scheduleDelayMillis = scheduleDelayMillis;
        return this;
    }

    long getScheduleDelayMillis() {
        return this.scheduleDelayMillis;
    }

    public BatchSpanProcessorBuilder setExporterTimeoutMillis(int exporterTimeoutMillis) {
        this.exporterTimeoutMillis = exporterTimeoutMillis;
        return this;
    }

    int getExporterTimeoutMillis() {
        return this.exporterTimeoutMillis;
    }

    public BatchSpanProcessorBuilder setMaxQueueSize(int maxQueueSize) {
        this.maxQueueSize = maxQueueSize;
        return this;
    }

    int getMaxQueueSize() {
        return this.maxQueueSize;
    }

    public BatchSpanProcessorBuilder setMaxExportBatchSize(int maxExportBatchSize) {
        Utils.checkArgument((maxExportBatchSize > 0 ? 1 : 0) != 0, (String)"maxExportBatchSize must be positive.");
        this.maxExportBatchSize = maxExportBatchSize;
        return this;
    }

    int getMaxExportBatchSize() {
        return this.maxExportBatchSize;
    }

    public BatchSpanProcessor build() {
        return new BatchSpanProcessor(this.spanExporter, this.exportOnlySampled, this.scheduleDelayMillis, this.maxQueueSize, this.maxExportBatchSize, this.exporterTimeoutMillis);
    }
}

