/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.trace;

import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.api.common.AttributeType;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;

final class StringUtils {
    static <T> T truncateToSize(AttributeKey<T> key, T value, int limit) {
        if (value == null || key.getType() != AttributeType.STRING && key.getType() != AttributeType.STRING_ARRAY) {
            return value;
        }
        if (key.getType() == AttributeType.STRING_ARRAY) {
            List strings = (List)value;
            if (strings.isEmpty()) {
                return value;
            }
            ArrayList<String> newStrings = new ArrayList<String>(strings.size());
            for (String string : strings) {
                newStrings.add(StringUtils.truncateToSize(string, limit));
            }
            return (T)newStrings;
        }
        return (T)StringUtils.truncateToSize((String)value, limit);
    }

    @Nullable
    private static String truncateToSize(@Nullable String s, int limit) {
        if (s == null || s.length() <= limit) {
            return s;
        }
        return s.substring(0, limit);
    }

    private StringUtils() {
    }
}

