/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.trace;

import io.opentelemetry.context.Context;
import io.opentelemetry.sdk.common.CompletableResultCode;
import io.opentelemetry.sdk.trace.MultiSpanProcessor;
import io.opentelemetry.sdk.trace.NoopSpanProcessor;
import io.opentelemetry.sdk.trace.ReadWriteSpan;
import io.opentelemetry.sdk.trace.ReadableSpan;
import java.util.ArrayList;
import java.util.Arrays;

public interface SpanProcessor {
    public static SpanProcessor composite(SpanProcessor ... processors) {
        return SpanProcessor.composite(Arrays.asList(processors));
    }

    public static SpanProcessor composite(Iterable<SpanProcessor> processors) {
        ArrayList<SpanProcessor> processorsList = new ArrayList<SpanProcessor>();
        for (SpanProcessor processor : processors) {
            processorsList.add(processor);
        }
        if (processorsList.isEmpty()) {
            return NoopSpanProcessor.getInstance();
        }
        if (processorsList.size() == 1) {
            return (SpanProcessor)processorsList.get(0);
        }
        return MultiSpanProcessor.create(processorsList);
    }

    public void onStart(Context var1, ReadWriteSpan var2);

    public boolean isStartRequired();

    public void onEnd(ReadableSpan var1);

    public boolean isEndRequired();

    default public CompletableResultCode shutdown() {
        return this.forceFlush();
    }

    default public CompletableResultCode forceFlush() {
        return CompletableResultCode.ofSuccess();
    }
}

