/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.trace;

import io.opentelemetry.api.trace.Tracer;
import io.opentelemetry.api.trace.TracerProvider;
import io.opentelemetry.sdk.common.Clock;
import io.opentelemetry.sdk.common.CompletableResultCode;
import io.opentelemetry.sdk.common.InstrumentationLibraryInfo;
import io.opentelemetry.sdk.internal.ComponentRegistry;
import io.opentelemetry.sdk.resources.Resource;
import io.opentelemetry.sdk.trace.IdGenerator;
import io.opentelemetry.sdk.trace.SdkTracer;
import io.opentelemetry.sdk.trace.SdkTracerManagement;
import io.opentelemetry.sdk.trace.SdkTracerProviderBuilder;
import io.opentelemetry.sdk.trace.SpanProcessor;
import io.opentelemetry.sdk.trace.TracerSharedState;
import io.opentelemetry.sdk.trace.config.TraceConfig;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;

public final class SdkTracerProvider
implements TracerProvider,
SdkTracerManagement {
    private static final Logger logger = Logger.getLogger(SdkTracerProvider.class.getName());
    static final String DEFAULT_TRACER_NAME = "unknown";
    private final TracerSharedState sharedState;
    private final ComponentRegistry<SdkTracer> tracerSdkComponentRegistry;

    public static SdkTracerProviderBuilder builder() {
        return new SdkTracerProviderBuilder();
    }

    SdkTracerProvider(Clock clock, IdGenerator idsGenerator, Resource resource, TraceConfig traceConfig) {
        this.sharedState = new TracerSharedState(clock, idsGenerator, resource, traceConfig);
        this.tracerSdkComponentRegistry = new ComponentRegistry(instrumentationLibraryInfo -> new SdkTracer(this.sharedState, (InstrumentationLibraryInfo)instrumentationLibraryInfo));
    }

    public Tracer get(String instrumentationName) {
        return this.get(instrumentationName, null);
    }

    public Tracer get(String instrumentationName, @Nullable String instrumentationVersion) {
        if (instrumentationName == null || instrumentationName.isEmpty()) {
            logger.fine("Tracer requested without instrumentation name.");
            instrumentationName = DEFAULT_TRACER_NAME;
        }
        return (Tracer)this.tracerSdkComponentRegistry.get(instrumentationName, instrumentationVersion);
    }

    @Override
    public TraceConfig getActiveTraceConfig() {
        return this.sharedState.getActiveTraceConfig();
    }

    @Override
    public void updateActiveTraceConfig(TraceConfig traceConfig) {
        this.sharedState.updateActiveTraceConfig(traceConfig);
    }

    @Override
    public void addSpanProcessor(SpanProcessor spanProcessor) {
        this.sharedState.addSpanProcessor(spanProcessor);
    }

    @Override
    public void shutdown() {
        if (this.sharedState.isStopped()) {
            logger.log(Level.WARNING, "Calling shutdown() multiple times.");
            return;
        }
        this.sharedState.stop();
    }

    @Override
    public CompletableResultCode forceFlush() {
        return this.sharedState.getActiveSpanProcessor().forceFlush();
    }
}

