/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.testing.assertj;

import io.opentelemetry.sdk.testing.assertj.TraceAssert;
import io.opentelemetry.sdk.trace.data.SpanData;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.assertj.core.api.AbstractIterableAssert;

public class TracesAssert
extends AbstractIterableAssert<TracesAssert, List<List<SpanData>>, List<SpanData>, TraceAssert> {
    public static TracesAssert assertThat(Collection<List<SpanData>> traces) {
        for (List<SpanData> trace : traces) {
            if (trace.stream().map(SpanData::getTraceId).distinct().count() == 1L) continue;
            throw new IllegalArgumentException("trace does not have consistent trace IDs, group spans into traces before calling this function: " + trace);
        }
        return new TracesAssert(new ArrayList<List<SpanData>>(traces));
    }

    TracesAssert(List<List<SpanData>> lists) {
        super(lists, TracesAssert.class);
    }

    @SafeVarargs
    public final TracesAssert hasTracesSatisfyingExactly(Consumer<TraceAssert> ... assertions) {
        this.hasSize(assertions.length);
        this.zipSatisfy(Arrays.asList(assertions), (trace, assertion) -> assertion.accept(new TraceAssert((List<SpanData>)trace)));
        return this;
    }

    protected TraceAssert toAssert(List<SpanData> value, String description) {
        return (TraceAssert)new TraceAssert(value).as(description, new Object[0]);
    }

    protected TracesAssert newAbstractIterableAssert(Iterable<? extends List<SpanData>> iterable) {
        return new TracesAssert(StreamSupport.stream(iterable.spliterator(), false).collect(Collectors.toList()));
    }
}

