/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.testing.context;

import io.opentelemetry.context.Context;
import io.opentelemetry.context.ContextStorage;
import io.opentelemetry.context.Scope;
import io.opentelemetry.context.internal.shaded.AbstractWeakConcurrentMap;
import io.opentelemetry.context.internal.shaded.WeakConcurrentMap;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;

public class StrictContextStorage
implements ContextStorage {
    static final Logger logger = Logger.getLogger(StrictContextStorage.class.getName());
    private final ContextStorage delegate;
    private final PendingScopes pendingScopes;

    public static StrictContextStorage create(ContextStorage delegate) {
        return new StrictContextStorage(delegate);
    }

    private StrictContextStorage(ContextStorage delegate) {
        this.delegate = delegate;
        this.pendingScopes = PendingScopes.create();
    }

    public Scope attach(Context context) {
        String className;
        int i;
        Scope scope = this.delegate.attach(context);
        CallerStackTrace caller = new CallerStackTrace(context);
        StackTraceElement[] stackTrace = caller.getStackTrace();
        for (i = 1; i < stackTrace.length && ((className = stackTrace[i].getClassName()).startsWith("io.opentelemetry.api.") || className.startsWith("io.opentelemetry.sdk.testing.context.SettableContextStorageProvider") || className.startsWith("io.opentelemetry.context.")); ++i) {
        }
        int from = i;
        stackTrace = Arrays.copyOfRange(stackTrace, from, stackTrace.length);
        caller.setStackTrace(stackTrace);
        return new StrictScope(scope, caller);
    }

    public Context current() {
        return this.delegate.current();
    }

    public void ensureAllClosed() {
        this.pendingScopes.expungeStaleEntries();
        List<CallerStackTrace> leaked = this.pendingScopes.drainPendingCallers();
        if (!leaked.isEmpty()) {
            if (leaked.size() > 1) {
                logger.log(Level.SEVERE, "Multiple scopes leaked - first will be thrown as an error.");
                for (CallerStackTrace caller : leaked) {
                    logger.log(Level.SEVERE, "Scope leaked", (Throwable)((Object)StrictContextStorage.callerError(caller)));
                }
            }
            throw StrictContextStorage.callerError(leaked.get(0));
        }
    }

    static AssertionError callerError(CallerStackTrace caller) {
        AssertionError toThrow = new AssertionError((Object)("Thread [" + caller.threadName + "] opened a scope of " + caller.context + " here:"));
        ((Throwable)((Object)toThrow)).setStackTrace(caller.getStackTrace());
        return toThrow;
    }

    static class PendingScopes
    extends WeakConcurrentMap<Scope, CallerStackTrace> {
        private final ConcurrentHashMap<AbstractWeakConcurrentMap.WeakKey<Scope>, CallerStackTrace> map;

        static PendingScopes create() {
            return new PendingScopes(new ConcurrentHashMap<AbstractWeakConcurrentMap.WeakKey<Scope>, CallerStackTrace>());
        }

        PendingScopes(ConcurrentHashMap<AbstractWeakConcurrentMap.WeakKey<Scope>, CallerStackTrace> map) {
            super(false, false, map);
            this.map = map;
            Thread thread = new Thread((Runnable)((Object)this));
            thread.setName("weak-ref-cleaner-strictcontextstorage");
            thread.setPriority(1);
            thread.setDaemon(true);
            thread.start();
        }

        List<CallerStackTrace> drainPendingCallers() {
            List<CallerStackTrace> pendingCallers = this.map.values().stream().filter(caller -> !caller.closed).collect(Collectors.toList());
            this.map.clear();
            return pendingCallers;
        }

        public void run() {
            try {
                while (!Thread.interrupted()) {
                    CallerStackTrace caller = this.map.remove(this.remove());
                    if (caller == null || caller.closed) continue;
                    logger.log(Level.SEVERE, "Scope garbage collected before being closed.", (Throwable)((Object)StrictContextStorage.callerError(caller)));
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    static class CallerStackTrace
    extends Throwable {
        private static final long serialVersionUID = 783294061323215387L;
        final String threadName = Thread.currentThread().getName();
        final long threadId = Thread.currentThread().getId();
        final Context context;
        volatile boolean closed;

        CallerStackTrace(Context context) {
            super("Thread [" + Thread.currentThread().getName() + "] opened scope for " + context + " here:");
            this.context = context;
        }
    }

    final class StrictScope
    implements Scope {
        final Scope delegate;
        final CallerStackTrace caller;

        StrictScope(Scope delegate, CallerStackTrace caller) {
            this.delegate = delegate;
            this.caller = caller;
            StrictContextStorage.this.pendingScopes.put(this, caller);
        }

        public void close() {
            this.caller.closed = true;
            StrictContextStorage.this.pendingScopes.remove(this);
            if (Thread.currentThread().getId() != this.caller.threadId) {
                throw new IllegalStateException(String.format("Thread [%s] opened scope, but thread [%s] closed it", this.caller.threadName, Thread.currentThread().getName()), this.caller);
            }
            this.delegate.close();
        }

        public String toString() {
            return this.caller.getMessage();
        }
    }
}

