/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.testing.trace;

import com.google.auto.value.AutoValue;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.common.ReadableAttributes;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.SpanId;
import io.opentelemetry.api.trace.TraceState;
import io.opentelemetry.sdk.common.InstrumentationLibraryInfo;
import io.opentelemetry.sdk.resources.Resource;
import io.opentelemetry.sdk.testing.trace.AutoValue_TestSpanData;
import io.opentelemetry.sdk.trace.data.SpanData;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.concurrent.Immutable;

@Immutable
@AutoValue
public abstract class TestSpanData
implements SpanData {
    public static Builder builder() {
        return new AutoValue_TestSpanData.Builder().setParentSpanId(SpanId.getInvalid()).setInstrumentationLibraryInfo(InstrumentationLibraryInfo.getEmpty()).setLinks(Collections.emptyList()).setTotalRecordedLinks(0).setAttributes((ReadableAttributes)Attributes.empty()).setEvents(Collections.emptyList()).setTotalRecordedEvents(0).setResource(Resource.getEmpty()).setTraceState(TraceState.getDefault()).setSampled(false).setHasRemoteParent(false).setTotalAttributeCount(0);
    }

    abstract boolean getInternalHasEnded();

    abstract boolean getInternalHasRemoteParent();

    public final boolean hasEnded() {
        return this.getInternalHasEnded();
    }

    public final boolean hasRemoteParent() {
        return this.getInternalHasRemoteParent();
    }

    @AutoValue.Builder
    public static abstract class Builder {
        abstract TestSpanData autoBuild();

        abstract List<SpanData.Event> getEvents();

        abstract List<SpanData.Link> getLinks();

        public TestSpanData build() {
            this.setEvents(Collections.unmodifiableList(new ArrayList<SpanData.Event>(this.getEvents())));
            this.setLinks(Collections.unmodifiableList(new ArrayList<SpanData.Link>(this.getLinks())));
            return this.autoBuild();
        }

        public abstract Builder setTraceId(String var1);

        public abstract Builder setSpanId(String var1);

        public abstract Builder setSampled(boolean var1);

        public abstract Builder setTraceState(TraceState var1);

        public abstract Builder setParentSpanId(String var1);

        public abstract Builder setResource(Resource var1);

        public abstract Builder setInstrumentationLibraryInfo(InstrumentationLibraryInfo var1);

        public abstract Builder setName(String var1);

        public abstract Builder setStartEpochNanos(long var1);

        public abstract Builder setEndEpochNanos(long var1);

        public abstract Builder setAttributes(ReadableAttributes var1);

        public abstract Builder setEvents(List<SpanData.Event> var1);

        public abstract Builder setStatus(SpanData.Status var1);

        public abstract Builder setKind(Span.Kind var1);

        public abstract Builder setLinks(List<SpanData.Link> var1);

        abstract Builder setInternalHasRemoteParent(boolean var1);

        public final Builder setHasRemoteParent(boolean hasRemoteParent) {
            return this.setInternalHasRemoteParent(hasRemoteParent);
        }

        abstract Builder setInternalHasEnded(boolean var1);

        public final Builder setHasEnded(boolean hasEnded) {
            return this.setInternalHasEnded(hasEnded);
        }

        public abstract Builder setTotalRecordedEvents(int var1);

        public abstract Builder setTotalRecordedLinks(int var1);

        public abstract Builder setTotalAttributeCount(int var1);
    }
}

