/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.testing.context;

import io.opentelemetry.context.Context;
import io.opentelemetry.context.ContextStorage;
import io.opentelemetry.context.ContextStorageProvider;
import io.opentelemetry.context.Scope;
import java.util.ArrayList;
import java.util.ServiceLoader;

public class SettableContextStorageProvider
implements ContextStorageProvider {
    public ContextStorage get() {
        return SettableContextStorage.INSTANCE;
    }

    public static void setContextStorage(ContextStorage storage) {
        SettableContextStorage.delegate = storage;
    }

    public static ContextStorage getContextStorage() {
        return SettableContextStorage.delegate;
    }

    private static enum SettableContextStorage implements ContextStorage
    {
        INSTANCE;

        private static volatile ContextStorage delegate;

        public Scope attach(Context toAttach) {
            return delegate.attach(toAttach);
        }

        public Context current() {
            return delegate.current();
        }

        private static ContextStorage createStorage() {
            ArrayList<ContextStorageProvider> providers = new ArrayList<ContextStorageProvider>();
            for (ContextStorageProvider provider : ServiceLoader.load(ContextStorageProvider.class)) {
                if (provider.getClass().equals(SettableContextStorageProvider.class)) continue;
                providers.add(provider);
            }
            if (providers.isEmpty()) {
                return ContextStorage.defaultStorage();
            }
            String providerClassName = System.getProperty("io.opentelemetry.context.contextStorageProvider", "");
            if (providerClassName.isEmpty()) {
                if (providers.size() == 1) {
                    return ((ContextStorageProvider)providers.get(0)).get();
                }
                return ContextStorage.defaultStorage();
            }
            for (ContextStorageProvider provider : providers) {
                if (!provider.getClass().getName().equals(providerClassName)) continue;
                return provider.get();
            }
            return ContextStorage.defaultStorage();
        }

        static {
            delegate = SettableContextStorage.createStorage();
        }
    }
}

