/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.context;

import io.opentelemetry.context.Context;
import io.opentelemetry.context.ContextKey;
import io.opentelemetry.context.ContextStorage;
import io.opentelemetry.context.PersistentHashArrayMappedTrie;
import io.opentelemetry.context.ThreadLocalContextStorage;
import javax.annotation.Nullable;

final class DefaultContext
implements Context {
    private static final Context ROOT = new DefaultContext();
    @Nullable
    private final PersistentHashArrayMappedTrie.Node<ContextKey<?>, Object> entries;

    static ContextStorage threadLocalStorage() {
        return ThreadLocalContextStorage.INSTANCE;
    }

    static Context root() {
        return ROOT;
    }

    private DefaultContext(PersistentHashArrayMappedTrie.Node<ContextKey<?>, Object> entries) {
        this.entries = entries;
    }

    DefaultContext() {
        this.entries = null;
    }

    @Override
    @Nullable
    public <V> V get(ContextKey<V> key) {
        Object value = PersistentHashArrayMappedTrie.get(this.entries, key);
        return (V)value;
    }

    @Override
    public <V> Context with(ContextKey<V> k1, V v1) {
        PersistentHashArrayMappedTrie.Node<ContextKey<?>, Object> newEntries = PersistentHashArrayMappedTrie.put(this.entries, k1, v1);
        return new DefaultContext(newEntries);
    }
}

