/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.context.propagation;

import io.grpc.Context;
import io.opentelemetry.context.propagation.ContextPropagators;
import io.opentelemetry.context.propagation.HttpTextFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class DefaultContextPropagators
implements ContextPropagators {
    private final HttpTextFormat textFormat;

    @Override
    public HttpTextFormat getHttpTextFormat() {
        return this.textFormat;
    }

    public static Builder builder() {
        return new Builder();
    }

    private DefaultContextPropagators(HttpTextFormat textFormat) {
        this.textFormat = textFormat;
    }

    private static final class NoopHttpTextFormat
    implements HttpTextFormat {
        private static final NoopHttpTextFormat INSTANCE = new NoopHttpTextFormat();

        private NoopHttpTextFormat() {
        }

        @Override
        public List<String> fields() {
            return Collections.emptyList();
        }

        @Override
        public <C> void inject(Context context, C carrier, HttpTextFormat.Setter<C> setter) {
        }

        @Override
        public <C> Context extract(Context context, C carrier, HttpTextFormat.Getter<C> getter) {
            return context;
        }
    }

    private static final class MultiHttpTextFormat
    implements HttpTextFormat {
        private final HttpTextFormat[] textPropagators;
        private final List<String> allFields;

        private MultiHttpTextFormat(List<HttpTextFormat> textPropagators) {
            this.textPropagators = new HttpTextFormat[textPropagators.size()];
            textPropagators.toArray(this.textPropagators);
            this.allFields = MultiHttpTextFormat.getAllFields(this.textPropagators);
        }

        @Override
        public List<String> fields() {
            return this.allFields;
        }

        private static List<String> getAllFields(HttpTextFormat[] textPropagators) {
            ArrayList<String> fields = new ArrayList<String>();
            for (int i = 0; i < textPropagators.length; ++i) {
                fields.addAll(textPropagators[i].fields());
            }
            return fields;
        }

        @Override
        public <C> void inject(Context context, C carrier, HttpTextFormat.Setter<C> setter) {
            for (int i = 0; i < this.textPropagators.length; ++i) {
                this.textPropagators[i].inject(context, carrier, setter);
            }
        }

        @Override
        public <C> Context extract(Context context, C carrier, HttpTextFormat.Getter<C> getter) {
            for (int i = 0; i < this.textPropagators.length; ++i) {
                context = this.textPropagators[i].extract(context, carrier, getter);
            }
            return context;
        }
    }

    public static final class Builder {
        List<HttpTextFormat> textPropagators = new ArrayList<HttpTextFormat>();

        public Builder addHttpTextFormat(HttpTextFormat textFormat) {
            if (textFormat == null) {
                throw new NullPointerException("textFormat");
            }
            this.textPropagators.add(textFormat);
            return this;
        }

        public ContextPropagators build() {
            if (this.textPropagators.isEmpty()) {
                return new DefaultContextPropagators(NoopHttpTextFormat.INSTANCE);
            }
            return new DefaultContextPropagators(new MultiHttpTextFormat(this.textPropagators));
        }
    }
}

