/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.correlationcontext;

import com.google.auto.value.AutoValue;
import io.opentelemetry.correlationcontext.AutoValue_Entry;
import io.opentelemetry.correlationcontext.EntryMetadata;
import io.opentelemetry.internal.StringUtils;
import io.opentelemetry.internal.Utils;
import javax.annotation.concurrent.Immutable;

@Immutable
@AutoValue
public abstract class Entry {
    public static final int MAX_KEY_LENGTH = 255;
    public static final int MAX_VALUE_LENGTH = 255;
    public static final EntryMetadata METADATA_UNLIMITED_PROPAGATION = EntryMetadata.create(EntryMetadata.EntryTtl.UNLIMITED_PROPAGATION);

    Entry() {
    }

    public static Entry create(String key, String value, EntryMetadata entryMetadata) {
        Utils.checkArgument(Entry.keyIsValid(key), "Invalid entry key name: %s", key);
        Utils.checkArgument(Entry.isValueValid(value), "Invalid entry value: %s", value);
        return new AutoValue_Entry(key, value, entryMetadata);
    }

    public abstract String getKey();

    public abstract String getValue();

    public abstract EntryMetadata getEntryMetadata();

    private static boolean keyIsValid(String name) {
        return !name.isEmpty() && name.length() <= 255 && StringUtils.isPrintableString(name);
    }

    private static boolean isValueValid(String value) {
        return value.length() <= 255 && StringUtils.isPrintableString(value);
    }
}

