/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.correlationcontext;

import io.opentelemetry.context.Scope;
import io.opentelemetry.correlationcontext.CorrelationContext;
import io.opentelemetry.correlationcontext.CorrelationContextManager;
import io.opentelemetry.correlationcontext.CorrelationsContextUtils;
import io.opentelemetry.correlationcontext.EmptyCorrelationContext;
import io.opentelemetry.correlationcontext.EntryMetadata;
import io.opentelemetry.internal.Utils;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public final class DefaultCorrelationContextManager
implements CorrelationContextManager {
    private static final DefaultCorrelationContextManager INSTANCE = new DefaultCorrelationContextManager();

    public static CorrelationContextManager getInstance() {
        return INSTANCE;
    }

    @Override
    public CorrelationContext getCurrentContext() {
        return CorrelationsContextUtils.getCurrentCorrelationContext();
    }

    @Override
    public CorrelationContext.Builder contextBuilder() {
        return new NoopCorrelationContextBuilder();
    }

    @Override
    public Scope withContext(CorrelationContext distContext) {
        return CorrelationsContextUtils.currentContextWith(distContext);
    }

    @Immutable
    private static final class NoopCorrelationContextBuilder
    implements CorrelationContext.Builder {
        private NoopCorrelationContextBuilder() {
        }

        @Override
        public CorrelationContext.Builder setParent(CorrelationContext parent) {
            Utils.checkNotNull(parent, "parent");
            return this;
        }

        @Override
        public CorrelationContext.Builder setNoParent() {
            return this;
        }

        @Override
        public CorrelationContext.Builder put(String key, String value, EntryMetadata entryMetadata) {
            Utils.checkNotNull(key, "key");
            Utils.checkNotNull(value, "value");
            Utils.checkNotNull(entryMetadata, "entryMetadata");
            return this;
        }

        @Override
        public CorrelationContext.Builder remove(String key) {
            Utils.checkNotNull(key, "key");
            return this;
        }

        @Override
        public CorrelationContext build() {
            return EmptyCorrelationContext.getInstance();
        }
    }
}

