/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.api;

import com.google.errorprone.annotations.concurrent.GuardedBy;
import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.api.trace.Tracer;
import io.opentelemetry.api.trace.TracerProvider;
import io.opentelemetry.context.propagation.ContextPropagators;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;

public final class GlobalOpenTelemetry {
    private static final Logger logger = Logger.getLogger(GlobalOpenTelemetry.class.getName());
    private static final Object mutex = new Object();
    @Nullable
    private static volatile ObfuscatedOpenTelemetry globalOpenTelemetry;
    @Nullable
    @GuardedBy(value="mutex")
    private static Throwable setGlobalCaller;

    private GlobalOpenTelemetry() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static OpenTelemetry get() {
        if (globalOpenTelemetry == null) {
            Object object = mutex;
            synchronized (object) {
                if (globalOpenTelemetry == null) {
                    OpenTelemetry autoConfigured = GlobalOpenTelemetry.maybeAutoConfigure();
                    if (autoConfigured != null) {
                        return autoConfigured;
                    }
                    GlobalOpenTelemetry.set(OpenTelemetry.noop());
                    return OpenTelemetry.noop();
                }
            }
        }
        return globalOpenTelemetry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void set(OpenTelemetry openTelemetry) {
        Object object = mutex;
        synchronized (object) {
            if (globalOpenTelemetry != null) {
                throw new IllegalStateException("GlobalOpenTelemetry.set has already been called. GlobalOpenTelemetry.set must be called only once before any calls to GlobalOpenTelemetry.get. If you are using the OpenTelemetrySdk, use OpenTelemetrySdkBuilder.buildAndRegisterGlobal instead. Previous invocation set to cause of this exception.", setGlobalCaller);
            }
            globalOpenTelemetry = new ObfuscatedOpenTelemetry(openTelemetry);
            setGlobalCaller = new Throwable();
        }
    }

    public static TracerProvider getTracerProvider() {
        return GlobalOpenTelemetry.get().getTracerProvider();
    }

    public static Tracer getTracer(String instrumentationName) {
        return GlobalOpenTelemetry.get().getTracer(instrumentationName);
    }

    public static Tracer getTracer(String instrumentationName, String instrumentationVersion) {
        return GlobalOpenTelemetry.get().getTracer(instrumentationName, instrumentationVersion);
    }

    public static void resetForTest() {
        globalOpenTelemetry = null;
    }

    public static ContextPropagators getPropagators() {
        return GlobalOpenTelemetry.get().getPropagators();
    }

    @Nullable
    private static OpenTelemetry maybeAutoConfigure() {
        Class<?> openTelemetrySdkAutoConfiguration;
        try {
            openTelemetrySdkAutoConfiguration = Class.forName("io.opentelemetry.sdk.autoconfigure.OpenTelemetrySdkAutoConfiguration");
        }
        catch (ClassNotFoundException e) {
            return null;
        }
        try {
            Method initialize = openTelemetrySdkAutoConfiguration.getMethod("initialize", new Class[0]);
            return (OpenTelemetry)initialize.invoke(null, new Object[0]);
        }
        catch (IllegalAccessException | NoSuchMethodException e) {
            throw new IllegalStateException("OpenTelemetrySdkAutoConfiguration detected on classpath but could not invoke initialize method. This is a bug in OpenTelemetry.", e);
        }
        catch (InvocationTargetException t) {
            logger.log(Level.SEVERE, "Error automatically configuring OpenTelemetry SDK. OpenTelemetry will not be enabled.", t.getTargetException());
            return null;
        }
    }

    @ThreadSafe
    static class ObfuscatedOpenTelemetry
    implements OpenTelemetry {
        private final OpenTelemetry delegate;

        ObfuscatedOpenTelemetry(OpenTelemetry delegate) {
            this.delegate = delegate;
        }

        @Override
        public TracerProvider getTracerProvider() {
            return this.delegate.getTracerProvider();
        }

        @Override
        public ContextPropagators getPropagators() {
            return this.delegate.getPropagators();
        }
    }
}

