/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.api.trace.propagation;

import io.opentelemetry.api.internal.Utils;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.SpanContext;
import io.opentelemetry.api.trace.SpanId;
import io.opentelemetry.api.trace.TraceFlags;
import io.opentelemetry.api.trace.TraceId;
import io.opentelemetry.api.trace.TraceState;
import io.opentelemetry.api.trace.TraceStateBuilder;
import io.opentelemetry.api.trace.propagation.TemporaryBuffers;
import io.opentelemetry.context.Context;
import io.opentelemetry.context.ImplicitContextKeyed;
import io.opentelemetry.context.propagation.TextMapPropagator;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class W3CTraceContextPropagator {
    private static final Logger logger = Logger.getLogger(W3CTraceContextPropagator.class.getName());
    private static final TraceState TRACE_STATE_DEFAULT = TraceState.builder().build();
    static final String TRACE_PARENT = "traceparent";
    static final String TRACE_STATE = "tracestate";
    private static final List<String> FIELDS = Collections.unmodifiableList(Arrays.asList("traceparent", "tracestate"));
    private static final String VERSION = "00";
    private static final int VERSION_SIZE = 2;
    private static final char TRACEPARENT_DELIMITER = '-';
    private static final int TRACEPARENT_DELIMITER_SIZE = 1;
    private static final int TRACE_ID_HEX_SIZE = TraceId.getHexLength();
    private static final int SPAN_ID_HEX_SIZE = SpanId.getHexLength();
    private static final int TRACE_OPTION_HEX_SIZE = TraceFlags.getHexLength();
    private static final int TRACE_ID_OFFSET = 3;
    private static final int SPAN_ID_OFFSET = 3 + TRACE_ID_HEX_SIZE + 1;
    private static final int TRACE_OPTION_OFFSET = SPAN_ID_OFFSET + SPAN_ID_HEX_SIZE + 1;
    private static final int TRACEPARENT_HEADER_SIZE = TRACE_OPTION_OFFSET + TRACE_OPTION_HEX_SIZE;
    private static final int TRACESTATE_MAX_SIZE = 512;
    private static final int TRACESTATE_MAX_MEMBERS = 32;
    private static final char TRACESTATE_KEY_VALUE_DELIMITER = '=';
    private static final char TRACESTATE_ENTRY_DELIMITER = ',';
    private static final Pattern TRACESTATE_ENTRY_DELIMITER_SPLIT_PATTERN = Pattern.compile("[ \t]*,[ \t]*");
    private static final Set<String> VALID_VERSIONS;
    private static final String VERSION_00 = "00";
    private static final TextMapPropagator INSTANCE;

    private W3CTraceContextPropagator() {
    }

    public static TextMapPropagator getInstance() {
        return INSTANCE;
    }

    private static <C> SpanContext extractImpl(C carrier, TextMapPropagator.Getter<C> getter) {
        String traceParent = getter.get(carrier, TRACE_PARENT);
        if (traceParent == null) {
            return SpanContext.getInvalid();
        }
        SpanContext contextFromParentHeader = W3CTraceContextPropagator.extractContextFromTraceParent(traceParent);
        if (!contextFromParentHeader.isValid()) {
            return contextFromParentHeader;
        }
        String traceStateHeader = getter.get(carrier, TRACE_STATE);
        if (traceStateHeader == null || traceStateHeader.isEmpty()) {
            return contextFromParentHeader;
        }
        try {
            TraceState traceState = W3CTraceContextPropagator.extractTraceState(traceStateHeader);
            return SpanContext.createFromRemoteParent(contextFromParentHeader.getTraceIdAsHexString(), contextFromParentHeader.getSpanIdAsHexString(), contextFromParentHeader.getTraceFlags(), traceState);
        }
        catch (IllegalArgumentException e) {
            logger.fine("Unparseable tracestate header. Returning span context without state.");
            return contextFromParentHeader;
        }
    }

    private static SpanContext extractContextFromTraceParent(String traceparent) {
        boolean isValid;
        boolean bl = isValid = (traceparent.length() == TRACEPARENT_HEADER_SIZE || traceparent.length() > TRACEPARENT_HEADER_SIZE && traceparent.charAt(TRACEPARENT_HEADER_SIZE) == '-') && traceparent.charAt(2) == '-' && traceparent.charAt(SPAN_ID_OFFSET - 1) == '-' && traceparent.charAt(TRACE_OPTION_OFFSET - 1) == '-';
        if (!isValid) {
            logger.fine("Unparseable traceparent header. Returning INVALID span context.");
            return SpanContext.getInvalid();
        }
        try {
            String version = traceparent.substring(0, 2);
            if (!VALID_VERSIONS.contains(version)) {
                return SpanContext.getInvalid();
            }
            if (version.equals("00") && traceparent.length() > TRACEPARENT_HEADER_SIZE) {
                return SpanContext.getInvalid();
            }
            String traceId = traceparent.substring(3, 3 + TraceId.getHexLength());
            String spanId = traceparent.substring(SPAN_ID_OFFSET, SPAN_ID_OFFSET + SpanId.getHexLength());
            if (TraceId.isValid(traceId) && SpanId.isValid(spanId)) {
                byte isSampled = TraceFlags.byteFromHex(traceparent, TRACE_OPTION_OFFSET);
                return SpanContext.createFromRemoteParent(traceId, spanId, isSampled, TRACE_STATE_DEFAULT);
            }
            return SpanContext.getInvalid();
        }
        catch (IllegalArgumentException e) {
            logger.fine("Unparseable traceparent header. Returning INVALID span context.");
            return SpanContext.getInvalid();
        }
    }

    private static TraceState extractTraceState(String traceStateHeader) {
        TraceStateBuilder traceStateBuilder = TraceState.builder();
        String[] listMembers = TRACESTATE_ENTRY_DELIMITER_SPLIT_PATTERN.split(traceStateHeader);
        Utils.checkArgument(listMembers.length <= 32, "TraceState has too many elements.");
        for (int i = listMembers.length - 1; i >= 0; --i) {
            String listMember = listMembers[i];
            int index = listMember.indexOf(61);
            Utils.checkArgument(index != -1, "Invalid TraceState list-member format.");
            traceStateBuilder.set(listMember.substring(0, index), listMember.substring(index + 1));
        }
        return traceStateBuilder.build();
    }

    static {
        INSTANCE = new TextMapPropagator(){

            public Collection<String> fields() {
                return FIELDS;
            }

            public <C> void inject(Context context, C carrier, TextMapPropagator.Setter<C> setter) {
                Objects.requireNonNull(context, "context");
                Objects.requireNonNull(setter, "setter");
                SpanContext spanContext = Span.fromContext(context).getSpanContext();
                if (!spanContext.isValid()) {
                    return;
                }
                char[] chars = TemporaryBuffers.chars(TRACEPARENT_HEADER_SIZE);
                chars[0] = "00".charAt(0);
                chars[1] = "00".charAt(1);
                chars[2] = 45;
                String traceId = spanContext.getTraceIdAsHexString();
                for (int i = 0; i < traceId.length(); ++i) {
                    chars[3 + i] = traceId.charAt(i);
                }
                chars[SPAN_ID_OFFSET - 1] = 45;
                String spanId = spanContext.getSpanIdAsHexString();
                for (int i = 0; i < spanId.length(); ++i) {
                    chars[SPAN_ID_OFFSET + i] = spanId.charAt(i);
                }
                chars[TRACE_OPTION_OFFSET - 1] = 45;
                spanContext.copyTraceFlagsHexTo(chars, TRACE_OPTION_OFFSET);
                setter.set(carrier, W3CTraceContextPropagator.TRACE_PARENT, new String(chars, 0, TRACEPARENT_HEADER_SIZE));
                TraceState traceState = spanContext.getTraceState();
                if (traceState.isEmpty()) {
                    return;
                }
                StringBuilder stringBuilder = new StringBuilder(512);
                traceState.forEach((key, value) -> {
                    if (stringBuilder.length() != 0) {
                        stringBuilder.append(',');
                    }
                    stringBuilder.append((String)key).append('=').append((String)value);
                });
                setter.set(carrier, W3CTraceContextPropagator.TRACE_STATE, stringBuilder.toString());
            }

            public <C> Context extract(Context context, @Nullable C carrier, TextMapPropagator.Getter<C> getter) {
                Objects.requireNonNull(context, "context");
                Objects.requireNonNull(getter, "getter");
                SpanContext spanContext = W3CTraceContextPropagator.extractImpl(carrier, getter);
                if (!spanContext.isValid()) {
                    return context;
                }
                return context.with((ImplicitContextKeyed)Span.wrap(spanContext));
            }
        };
        VALID_VERSIONS = new HashSet<String>();
        for (int i = 0; i < 255; ++i) {
            String version = Long.toHexString(i);
            if (version.length() < 2) {
                version = '0' + version;
            }
            VALID_VERSIONS.add(version);
        }
    }
}

